/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.exception.SysException;
import com.ovopark.passenger.feign.DepartmentFeign;
import com.ovopark.passenger.mapper.DeviceFlowTagMapper;
import com.ovopark.passenger.mapper.ShopFlowTagMapper;
import com.ovopark.passenger.model.DeviceFlowTagModel;
import com.ovopark.passenger.model.ShopFlowTagModel;
import com.ovopark.passenger.service.ShopFlowTagService;
import com.ovopark.pojo.ShopFlowTagPojo;
import com.ovopark.pojo.dto.DepartmentDto;
import com.ovopark.pojo.dto.ShopFlowTagDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="shopFlowTagService")
public class ShopFlowTagServiceImpl
extends ServiceImpl<ShopFlowTagMapper, ShopFlowTagModel>
implements ShopFlowTagService {
    @Resource
    private ShopFlowTagMapper shopFlowTagMapper;
    @Resource
    private DeviceFlowTagMapper deviceFlowTagMapper;
    @Resource
    private DepartmentFeign departmentFeign;
    @Resource
    private MessageSource messageSource;
    @Resource
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Resource
    private DepartmentApi departmentApi;

    @Override
    public ShopFlowTagModel saveShopFlowTag(ShopFlowTagModel tag) {
        if (Objects.nonNull(tag.getId())) {
            ShopFlowTagModel shopFlowTag = (ShopFlowTagModel)((Object)this.shopFlowTagMapper.selectById(tag.getId()));
            if (Objects.isNull((Object)shopFlowTag)) {
                throw new SysException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
            }
            if (shopFlowTag.getCanDelete() == 0) {
                throw new SysException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
            }
            Integer count = this.shopFlowTagMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ShopFlowTagModel::getIsDelete, (Object)0)).eq(ShopFlowTagModel::getDeptId, (Object)tag.getDeptId())).eq(ShopFlowTagModel::getPid, (Object)tag.getPid())).eq(ShopFlowTagModel::getName, (Object)tag.getName())).ne(ShopFlowTagModel::getId, (Object)tag.getId()));
            if (count > 0) {
                throw new SysException(ResultCodeEnum.DUPLICATE_DATA.getCode(), ResultCodeEnum.DUPLICATE_DATA.getMessage());
            }
            this.shopFlowTagMapper.updateById((Object)tag);
        } else {
            Integer count = this.shopFlowTagMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ShopFlowTagModel::getIsDelete, (Object)0)).eq(ShopFlowTagModel::getDeptId, (Object)tag.getDeptId())).eq(ShopFlowTagModel::getPid, (Object)tag.getPid())).eq(ShopFlowTagModel::getName, (Object)tag.getName()));
            if (count > 0) {
                throw new SysException(ResultCodeEnum.DUPLICATE_DATA.getCode(), ResultCodeEnum.DUPLICATE_DATA.getMessage());
            }
            this.shopFlowTagMapper.insert((Object)tag);
        }
        return (ShopFlowTagModel)((Object)this.shopFlowTagMapper.selectById(tag.getId()));
    }

    @Override
    public void deleteShopFlowTag(Integer id, Integer dataType) {
        ShopFlowTagModel shopFlowTag = (ShopFlowTagModel)((Object)this.shopFlowTagMapper.selectById(id));
        if (Objects.isNull((Object)shopFlowTag)) {
            throw new SysException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
        if (shopFlowTag.getCanDelete() == 0) {
            throw new SysException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
        shopFlowTag.setIsDelete(1);
        this.shopFlowTagMapper.updateById((Object)shopFlowTag);
        List<ShopFlowTagModel> tagList = this.shopFlowTagMapper.getListByPid(id);
        dataType = Objects.isNull(dataType) ? 0 : dataType;
        this.deleteSubs(tagList, dataType);
    }

    private void deleteSubs(List<ShopFlowTagModel> tagList, Integer dataType) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tagList)) {
            for (ShopFlowTagModel t : tagList) {
                t.setIsDelete(1);
                this.shopFlowTagMapper.updateById((Object)t);
                this.deviceFlowTagMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(DeviceFlowTagModel::getIsDelete, (Object)1)).eq(DeviceFlowTagModel::getTagId, (Object)t.getId())).eq(DeviceFlowTagModel::getDataType, (Object)dataType));
                List<ShopFlowTagModel> subs = this.shopFlowTagMapper.getListByPid(t.getId());
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(subs)) continue;
                this.deleteSubs(subs, dataType);
            }
        }
    }

    @Override
    public ShopFlowTagPojo findShopFlowTagByDeptIdAndTagType(Integer deptId, Integer tagType) {
        List<ShopFlowTagModel> shopFlowTags = this.shopFlowTagMapper.findByDeptIdAndTagType(deptId, tagType);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopFlowTags)) {
            ShopFlowTagPojo pojo = new ShopFlowTagPojo();
            BeanUtils.copyProperties((Object)((Object)shopFlowTags.get(0)), (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public void insertSubLevleTag(Integer deptId, String pName, String name, Integer canDelete, Integer isPrimaryPort, Integer tagType) {
        DepartmentDto dep = this.departmentFeign.getById(deptId);
        if (dep == null) {
            return;
        }
        Integer tagId = this.shopFlowTagMapper.selectTagIdByDeptAndName(deptId, pName);
        this.shopFlowTagMapper.insertSubLevleTag(deptId, dep.getGroupId(), tagId, name, canDelete, isPrimaryPort, tagType);
    }

    @Override
    public void insertSubLevelTag(Integer depId, Integer enterpriseId, String pName, String name, Integer canDelete, Integer isPrimaryPort, Integer tagType) {
        Integer tagId = this.shopFlowTagMapper.selectTagIdByDeptAndName(depId, pName);
        this.shopFlowTagMapper.insertSubLevleTag(depId, enterpriseId, tagId, name, canDelete, isPrimaryPort, tagType);
    }

    @Override
    public List<ShopFlowTagModel> listSubSysTag(Integer depId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).isNotNull(ShopFlowTagModel::getPid)).eq(ShopFlowTagModel::getCanDelete, (Object)0)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public List<ShopFlowTagModel> listAllSysTag(Integer depId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getCanDelete, (Object)0)).list();
    }

    @Override
    public void deleteTag(ShopFlowTagModel tag) {
        tag.setIsDelete(1);
        this.shopFlowTagMapper.updateById((Object)tag);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ShopFlowTagModel::getPid, (Object)tag.getId())).set(ShopFlowTagModel::getIsDelete, (Object)1)).update();
    }

    @Override
    public Boolean hasInit(Integer deptId, Integer isPrimaryPort) {
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findShopFlowTagByDepIdAndIsPrimaryPort(deptId, isPrimaryPort);
        if (CollectionUtils.isEmpty(shopFlowTagList)) {
            return false;
        }
        return true;
    }

    @Override
    public List<ShopFlowTagPojo> findOneLevelsByDeptId(Integer deptId) {
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findOneLevelsByDeptId(deptId);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<Integer> findPrimaryTagIdsByDepId(Integer depId) {
        return this.shopFlowTagMapper.findPrimaryTagIdsByDepId(depId);
    }

    @Override
    public List<Integer> findPrimaryTagIdsByDepIds(List<Integer> depIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<Integer>();
        }
        return this.shopFlowTagMapper.findPrimaryTagIdsByDepIds(depIds);
    }

    @Override
    public ShopFlowTagPojo findPrimaryTagByDepId(Integer depId) {
        List<ShopFlowTagModel> shopFlowTags = this.shopFlowTagMapper.findPrimaryTagByDepId(depId);
        if (!CollectionUtils.isEmpty(shopFlowTags)) {
            ShopFlowTagPojo pojo = new ShopFlowTagPojo();
            BeanUtils.copyProperties((Object)((Object)shopFlowTags.get(0)), (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public List<ShopFlowTagPojo> findPrimaryTagsByDepIds(List<Integer> depIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<ShopFlowTagPojo>();
        }
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findPrimaryTagsByDepIds(depIds);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<ShopFlowTagPojo> findByDeptIdsAndTagType(List<Integer> depIds, int tagType) {
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findByDeptIdsAndTagType(depIds, tagType);
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<ShopFlowTagPojo> findByDeptIdsAndTagType(String depIdStr, int tagType) {
        if (StringUtils.isEmpty((CharSequence)depIdStr)) {
            return new ArrayList<ShopFlowTagPojo>();
        }
        return this.findByDeptIdsAndTagType(Arrays.stream(depIdStr.split(",")).map(a -> Integer.valueOf(a)).collect(Collectors.toList()), tagType);
    }

    @Override
    public ShopFlowTagPojo findShopFlowTagById(int id) {
        ShopFlowTagModel shopFlowTag = this.shopFlowTagMapper.findById(id);
        ShopFlowTagPojo pojo = new ShopFlowTagPojo();
        if (shopFlowTag != null) {
            BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public void setDefaultTag(Integer deptId, Integer isPrimaryPort) {
        try {
            DepartmentDto dep = this.departmentFeign.getById(deptId);
            if (dep == null) {
                return;
            }
            if (isPrimaryPort == 1) {
                this.shopFlowTagMapper.insertOneLevleTag(deptId, dep.getGroupId(), "\u51fa\u5165\u53e3", 0, 1, 4);
                Integer tagId = this.shopFlowTagMapper.selectTagIdByDeptAndName(deptId, "\u51fa\u5165\u53e3");
                this.shopFlowTagMapper.insertSubLevleTag1(deptId, dep.getGroupId(), tagId, "\u4e3b\u51fa\u5165\u53e3", 0, 1);
            } else {
                this.shopFlowTagMapper.insertOneLevleTag(deptId, dep.getGroupId(), "\u533a\u57df", 0, 0, 1);
                this.shopFlowTagMapper.insertOneLevleTag(deptId, dep.getGroupId(), "\u4e1a\u6001", 0, 0, 2);
                this.shopFlowTagMapper.insertOneLevleTag(deptId, dep.getGroupId(), "\u54c1\u724c", 0, 0, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ShopFlowTagPojo> findSubLevelsByPid(Integer pid) {
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findSubLevelsByPid(pid);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<Map<String, Object>> getTagDistributionMapLinkedToFlow(Integer tagPId) {
        return this.shopFlowTagMapper.getTagDistributionMapLinkedToFlow(tagPId);
    }

    @Override
    public List<ShopFlowTagPojo> getShopFlowTagByTagIds(List<Integer> tagIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tagIds)) {
            return new ArrayList<ShopFlowTagPojo>();
        }
        List<ShopFlowTagModel> list = this.shopFlowTagMapper.selectByIds(tagIds);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(list)) {
            for (ShopFlowTagModel shopFlowTag : list) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<ShopFlowTagPojo> findTagByDepIdsAndType(List<Integer> depIds, Integer tagType) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<ShopFlowTagPojo>();
        }
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findTagByDepIdsAndType(depIds, tagType);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<ShopFlowTagPojo> findTagsHavingDeviceByTagIds(List<Integer> tagIds) {
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.findTagsHavingDeviceByTagIds(tagIds);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public void repairMainEntrance(Integer depId) {
        if (depId == null) {
            return;
        }
        if (!this.hasInit(depId, 1).booleanValue()) {
            this.setDefaultTag(depId, 1);
        }
        this.correctFailedToCreatePrimaryPortTag(depId);
    }

    @Override
    public void correctFailedToCreatePrimaryPortTag(Integer depId) {
        DepartmentDto dep = this.departmentFeign.getById(depId);
        if (dep == null) {
            return;
        }
        ShopFlowTagPojo primaryTag = this.findPrimaryTagByDepId(depId);
        if (primaryTag == null) {
            List<ShopFlowTagModel> primaryTags = this.shopFlowTagMapper.findShopFlowTagByDepIdAndIsPrimaryPort(depId, 1);
            if (!CollectionUtils.isEmpty(primaryTags)) {
                for (ShopFlowTagModel tag2 : primaryTags) {
                    if (!"\u4e3b\u51fa\u5165\u53e3".equals(tag2.getName())) continue;
                    return;
                }
                ArrayList<Integer> deleteTagIds = new ArrayList<Integer>();
                if (!CollectionUtils.isEmpty(primaryTags = primaryTags.stream().filter(tag -> "\u51fa\u5165\u53e3".equals(tag.getName())).collect(Collectors.toList())) && primaryTags.size() > 1) {
                    for (int i = 1; i < primaryTags.size(); ++i) {
                        deleteTagIds.add(primaryTags.get(i).getId());
                    }
                }
                if (!CollectionUtils.isEmpty(deleteTagIds)) {
                    this.shopFlowTagMapper.deleteByIds(deleteTagIds);
                }
                Integer tagId = this.shopFlowTagMapper.selectTagIdByDeptAndName(depId, "\u51fa\u5165\u53e3");
                this.shopFlowTagMapper.insertSubLevleTag1(depId, dep.getGroupId(), tagId, "\u4e3b\u51fa\u5165\u53e3", 0, 1);
            } else {
                this.shopFlowTagMapper.insertOneLevleTag(depId, dep.getGroupId(), "\u51fa\u5165\u53e3", 0, 1, 4);
                Integer tagId = this.shopFlowTagMapper.selectTagIdByDeptAndName(depId, "\u51fa\u5165\u53e3");
                this.shopFlowTagMapper.insertSubLevleTag1(depId, dep.getGroupId(), tagId, "\u4e3b\u51fa\u5165\u53e3", 0, 1);
            }
        }
    }

    @Override
    public List<ShopFlowTagPojo> getAllSecondLevelTagsByDepId(Integer depId) {
        return this.shopFlowTagMapper.getAllSecondLevelTagsByDepId(depId);
    }

    @Override
    public ShopFlowTagDto getShopFlowTagByDepIdAndTagType(Integer depId, Integer tagType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)tagType)).isNotNull(ShopFlowTagModel::getPid)).eq(ShopFlowTagModel::getIsDelete, (Object)0);
        List shopFlowTags = this.list((Wrapper)wrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)shopFlowTags)) {
            return this.shopFlowTagPo2Dto((ShopFlowTagModel)((Object)shopFlowTags.get(0)));
        }
        return null;
    }

    @Override
    public ShopFlowTagDto getPrimaryTagByDepId(Integer depId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)0)).eq(ShopFlowTagModel::getIsPrimaryPort, (Object)1)).eq(ShopFlowTagModel::getIsDelete, (Object)0);
        return this.shopFlowTagPo2Dto((ShopFlowTagModel)((Object)this.getOne((Wrapper)wrapper)));
    }

    @Override
    public void saveOrUpdateShopFlowTags(List<ShopFlowTagDto> tags) {
        tags.stream().map(t -> this.shopFlowTagDto2Po((ShopFlowTagDto)t)).forEach(arg_0 -> ((ShopFlowTagServiceImpl)this).saveOrUpdate(arg_0));
    }

    @Override
    public ShopFlowTagDto createProductTag(Integer depId) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)8)).isNull(ShopFlowTagModel::getPid)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)list)) {
            DepartmentDto dep = this.departmentFeign.getById(depId);
            if (dep != null) {
                ShopFlowTagModel tag = new ShopFlowTagModel();
                tag.setDeptId(depId);
                tag.setEnterpriseId(dep.getGroupId());
                tag.setName("\u5546\u54c1");
                tag.setIsDelete(0);
                tag.setCanDelete(0);
                tag.setIsPrimaryPort(0);
                tag.setTagType(8);
                this.save((Object)tag);
                return this.shopFlowTagPo2Dto(tag);
            }
        } else {
            return this.shopFlowTagPo2Dto((ShopFlowTagModel)((Object)list.get(0)));
        }
        return null;
    }

    @Override
    public ShopFlowTagDto saveShopFlowTag(ShopFlowTagDto tag) {
        ShopFlowTagModel po = this.shopFlowTagDto2Po(tag);
        boolean save = this.save((Object)po);
        return save ? tag.setId(po.getId()) : tag;
    }

    @Override
    public List<ShopFlowTagDto> listTagHavingDeviceByDepIds(List<Integer> depIds) {
        return this.shopFlowTagMapper.listTagHavingDeviceByDepIds(depIds);
    }

    @Override
    public void deleteByIds(List<Integer> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ShopFlowTagModel::getId, ids)).eq(ShopFlowTagModel::getCanDelete, (Object)1)).set(ShopFlowTagModel::getIsDelete, (Object)1)).update();
    }

    @Override
    public Boolean haveSubLevelsByPid(Integer pid) {
        boolean isResult = false;
        List<ShopFlowTagModel> shopFlowTag = this.shopFlowTagMapper.getListByPid(pid);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopFlowTag)) {
            isResult = true;
        }
        return isResult;
    }

    @Override
    public List<ShopFlowTagPojo> getListByPid(Integer pid) {
        List<ShopFlowTagModel> shopFlowTagList = this.shopFlowTagMapper.getListByPid(pid);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty(shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public List<ShopFlowTagPojo> getOneLevelsByDeptId(List<Integer> depIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(ShopFlowTagModel::getDeptId, depIds);
        query.isNull(ShopFlowTagModel::getPid);
        query.eq(ShopFlowTagModel::getIsDelete, (Object)0);
        List shopFlowTagList = this.shopFlowTagMapper.selectList((Wrapper)query);
        ArrayList<ShopFlowTagPojo> pojoList = new ArrayList<ShopFlowTagPojo>();
        if (!CollectionUtils.isEmpty((Collection)shopFlowTagList)) {
            for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
                ShopFlowTagPojo pojo = new ShopFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
                pojoList.add(pojo);
            }
        }
        return pojoList;
    }

    @Override
    public ShopFlowTagPojo getPrimaryPortByDeptId(Integer deptId) {
        ShopFlowTagModel shopFlowTag = this.shopFlowTagMapper.getPrimaryPortByDeptId(deptId);
        ShopFlowTagPojo pojo = new ShopFlowTagPojo();
        if (shopFlowTag != null) {
            BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
            return pojo;
        }
        return null;
    }

    @Override
    public Map<String, Object> findShopFlowTagsByFilterName(String filterName, Integer userId, Integer groupId, Locale locale, Integer pageNum, Integer pageSize) {
        HashMap map = Maps.newHashMap();
        map.put("totalResult", 0);
        map.put("list", new ArrayList());
        BaseResult baseResult = this.userDepPrivilegeApi.getPrivilegeDepIdByUserIdAndGroupId(userId, groupId, Boolean.valueOf(true));
        if (!baseResult.getIsError().booleanValue() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((Collection)baseResult.getData()))) {
            List shopList = (List)baseResult.getData();
            ArrayList<Integer> tagTypes = new ArrayList<Integer>();
            if (Objects.nonNull(locale)) {
                int canNotDeleteTagSize = 7;
                for (int i = 0; i < canNotDeleteTagSize + 1; ++i) {
                    String tagName = this.messageSource.getMessage("shop.flow.tag.type." + i, null, locale);
                    if (!StringUtils.isNotBlank((CharSequence)tagName) || !tagName.contains(filterName)) continue;
                    tagTypes.add(i);
                }
            }
            com.ovopark.passenger.model.Page result = new com.ovopark.passenger.model.Page();
            if (Objects.isNull(pageNum) || Objects.isNull(pageSize)) {
                result.setPageNum(1);
                result.setPageSize(Integer.MAX_VALUE);
            } else {
                result.setPageNum(pageNum);
                result.setPageSize(pageSize);
            }
            Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
            this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ShopFlowTagModel::getDeptId, (Collection)shopList)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).and(wq -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(ShopFlowTagModel::getName, (Object)filterName)).or()).in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)tagTypes), ShopFlowTagModel::getTagType, (Collection)tagTypes);
            }));
            List records = page.getRecords();
            List deptIds = records.stream().map(a -> a.getDeptId()).distinct().collect(Collectors.toList());
            BaseResult departmentByIds = this.departmentApi.getDepartmentByIds(deptIds);
            Map<Object, Object> deptNameMap = Maps.newHashMap();
            if (!departmentByIds.getIsError().booleanValue()) {
                deptNameMap = ((List)departmentByIds.getData()).stream().collect(Collectors.toMap(a -> a.getId(), a -> a.getName(), (x, y) -> x));
            }
            for (int i = 0; i < records.size(); ++i) {
                ShopFlowTagModel tag = (ShopFlowTagModel)((Object)records.get(i));
                if (tag.getTagType() > 0 || tag.getIsPrimaryPort() == 1 && tag.getTagType() == 0) {
                    tag.setName(this.messageSource.getMessage("shop.flow.tag.type." + tag.getTagType(), null, locale));
                }
                tag.setDeptName((String)deptNameMap.get(tag.getDeptId()));
            }
            map.put("totalResult", page.getTotal());
            map.put("list", page.getRecords());
        }
        return map;
    }

    @Override
    public String getTagName(Locale locale, Integer tagType, Integer isPrimaryPort, String tagName) {
        if (locale == null || tagType == null || isPrimaryPort == null) {
            return tagName;
        }
        if (tagType > 0 || isPrimaryPort == 1 && tagType == 0) {
            return this.messageSource.getMessage("shop.flow.tag.type." + tagType, null, locale);
        }
        return tagName;
    }

    @Override
    public List<ShopFlowTagModel> listTagCategoryByEnterpriseId(Integer enterpriseId) {
        if (enterpriseId == null) {
            return new ArrayList<ShopFlowTagModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getEnterpriseId, (Object)enterpriseId)).isNotNull(ShopFlowTagModel::getPid)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).groupBy((Object[])new SFunction[]{ShopFlowTagModel::getCanDelete, ShopFlowTagModel::getTagType, ShopFlowTagModel::getName})).list();
    }

    @Override
    public List<Integer> getStaircaseTagIds(List<Integer> depIds) {
        return this.getStaircaseTags(depIds).stream().map(ShopFlowTagModel::getId).collect(Collectors.toList());
    }

    private List<ShopFlowTagModel> getStaircaseTags(List<Integer> depIds) {
        return this.listByTagType(depIds, 9);
    }

    @Override
    public Integer getCashierTagId(Integer depId) {
        if (depId == null) {
            return null;
        }
        return this.listByTagType(Collections.singletonList(depId), 7).stream().findFirst().map(ShopFlowTagModel::getId).orElse(null);
    }

    private List<ShopFlowTagModel> listByTagType(List<Integer> depIds, int tagType) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<ShopFlowTagModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ShopFlowTagModel::getDeptId, depIds)).eq(ShopFlowTagModel::getTagType, (Object)tagType)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public ShopFlowTagModel getPrimaryTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)0)).eq(ShopFlowTagModel::getIsPrimaryPort, (Object)1)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public ShopFlowTagModel getEntranceTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)4)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public ShopFlowTagModel getPassTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)6)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public ShopFlowTagModel getFittingTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)5)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public ShopFlowTagModel getStaircaseTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)9)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public ShopFlowTagModel getCashierTag(Integer depId) {
        if (depId == null) {
            return null;
        }
        return (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)7)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
    }

    @Override
    public List<Integer> getIdsByPIds(List<Integer> pIds) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ShopFlowTagModel::getPid, pIds)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list().stream().map(ShopFlowTagModel::getId).collect(Collectors.toList());
    }

    @Override
    public List<Integer> getIdsByPId(Integer pId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getPid, (Object)pId)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list().stream().map(ShopFlowTagModel::getId).collect(Collectors.toList());
    }

    @Override
    public List<ShopFlowTagModel> listByDepIdForRobot(Integer deptId) {
        LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(ShopFlowTagModel::getDeptId, (Object)deptId)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).isNotNull(ShopFlowTagModel::getPid)).eq(ShopFlowTagModel::getIsPrimaryPort, (Object)1)).eq(ShopFlowTagModel::getTagType, (Object)0);
        return this.list((Wrapper)lambdaQuery);
    }

    @Override
    public List<ShopFlowTagModel> listByPId(Integer pId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getPid, (Object)pId)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public List<Integer> getNeedFixStairDepIds() {
        return this.shopFlowTagMapper.getNeedFixStairDepIds();
    }

    public ShopFlowTagDto shopFlowTagPo2Dto(ShopFlowTagModel po) {
        if (po == null) {
            return null;
        }
        ShopFlowTagDto dto = new ShopFlowTagDto();
        dto.setId(po.getId()).setDeptId(po.getDeptId()).setEnterpriseId(po.getEnterpriseId()).setName(po.getName()).setIsDelete(po.getIsDelete()).setPid(po.getPid()).setCanDelete(po.getCanDelete()).setIsPrimaryPort(po.getIsPrimaryPort()).setTagType(po.getTagType());
        return dto;
    }

    public ShopFlowTagModel shopFlowTagDto2Po(ShopFlowTagDto dto) {
        if (dto == null) {
            return null;
        }
        ShopFlowTagModel po = new ShopFlowTagModel();
        po.setId(dto.getId()).setDeptId(dto.getDeptId()).setEnterpriseId(dto.getEnterpriseId()).setName(dto.getName()).setIsDelete(dto.getIsDelete()).setPid(dto.getPid()).setCanDelete(dto.getCanDelete()).setIsPrimaryPort(dto.getIsPrimaryPort()).setTagType(dto.getTagType());
        return po;
    }

    @Override
    public ShopFlowTagDto getShopFlowTagById(Integer id) {
        return this.shopFlowTagPo2Dto((ShopFlowTagModel)((Object)this.getById(id)));
    }

    @Override
    public Integer getProductTagId(Integer depId) {
        if (depId == null) {
            return null;
        }
        ShopFlowTagModel one = (ShopFlowTagModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getTagType, (Object)8)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).last("limit 1")).one());
        return one == null ? null : one.getId();
    }

    @Override
    public List<ShopFlowTagPojo> listShopFlowsByParentId(Integer depId, Integer parentId) {
        ArrayList<ShopFlowTagPojo> result = new ArrayList<ShopFlowTagPojo>();
        if (Objects.isNull(depId) || Objects.isNull(parentId)) {
            return result;
        }
        List shopFlowTagList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ShopFlowTagModel::getDeptId, (Object)depId)).eq(ShopFlowTagModel::getPid, (Object)parentId)).eq(ShopFlowTagModel::getIsDelete, (Object)0)).list();
        for (ShopFlowTagModel shopFlowTag : shopFlowTagList) {
            ShopFlowTagPojo pojo = new ShopFlowTagPojo();
            BeanUtils.copyProperties((Object)((Object)shopFlowTag), (Object)pojo);
            result.add(pojo);
        }
        return result;
    }

    @Override
    public List<Integer> getPrimaryBroTagIdsByDepIds(List<Integer> depIds) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return result;
        }
        List<ShopFlowTagModel> models = this.getPrimaryBroTagModelsByDepIds(depIds);
        return models.stream().map(ShopFlowTagModel::getId).collect(Collectors.toList());
    }

    @Override
    public List<ShopFlowTagModel> getPrimaryBroTagModelsByDepIds(List<Integer> depIds) {
        List<ShopFlowTagModel> result = new ArrayList<ShopFlowTagModel>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds)) {
            return result;
        }
        List<Integer> entranceExitTagIds = this.shopFlowTagMapper.getEntranceExitTagModelsByDepIds(depIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entranceExitTagIds)) {
            return result;
        }
        result = this.shopFlowTagMapper.getPrimaryBroTagModelsByDepIds(depIds, entranceExitTagIds);
        return result;
    }
}

