/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.ovopark.passenger.mapper.ValidPassConfigMapper;
import com.ovopark.passenger.model.BaseModel;
import com.ovopark.passenger.model.ValidPassConfigDetailModel;
import com.ovopark.passenger.model.ValidPassConfigModel;
import com.ovopark.passenger.service.ValidPassConfigDetailService;
import com.ovopark.passenger.service.ValidPassConfigService;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ValidPassConfigServiceImpl
extends ServiceImpl<ValidPassConfigMapper, ValidPassConfigModel>
implements ValidPassConfigService {
    @Resource
    private ValidPassConfigDetailService validPassConfigDetailService;

    @Override
    public Page<ValidPassConfigModel> pageByDepIds(List<Integer> depIds, Integer pageNum, Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ValidPassConfigModel::getDepId, depIds)).eq(ValidPassConfigModel::getIsDelete, (Object)false)).page((IPage)page);
    }

    @Override
    public List<ValidPassConfigModel> listAllByDepIds(Integer enterpriseId, List<Long> depIds) {
        if (depIds == null || CollectionUtils.isEmpty(depIds)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseModel::getEnterpriseId, (Object)enterpriseId)).in(ValidPassConfigModel::getDepId, depIds)).list();
    }

    @Override
    public boolean isValid(Integer enterpriseId, Integer depId, Date recordTime, Integer stayTime, Integer age) {
        if (enterpriseId == null || depId == null || recordTime == null || stayTime == null || age == null) {
            return false;
        }
        ValidPassConfigModel validPassConfig = (ValidPassConfigModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseModel::getEnterpriseId, (Object)enterpriseId)).eq(ValidPassConfigModel::getDepId, (Object)depId)).eq(ValidPassConfigModel::getIsDelete, (Object)false)).one());
        if (validPassConfig == null) {
            return true;
        }
        if (stayTime.compareTo(validPassConfig.getStayTime()) < 0) {
            return false;
        }
        List<ValidPassConfigDetailModel> validPassConfigDetailModels = this.validPassConfigDetailService.listByConfigIds(Lists.newArrayList((Object[])new Long[]{validPassConfig.getId()}));
        if (CollectionUtils.isEmpty(validPassConfigDetailModels)) {
            return true;
        }
        for (ValidPassConfigDetailModel validPassConfigDetailModel : validPassConfigDetailModels) {
            String recordTimeStr = TimeUtils.formatDate(recordTime, "HH:mm");
            if (recordTimeStr.compareTo(validPassConfigDetailModel.getFromTime()) < 0 || recordTimeStr.compareTo(validPassConfigDetailModel.getToTime()) > 0 || age.compareTo(validPassConfigDetailModel.getFromAge()) < 0 || age.compareTo(validPassConfigDetailModel.getToAge()) > 0) continue;
            return false;
        }
        return true;
    }
}

