/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.resp;

import com.alibaba.fastjson.JSON;
import com.ovopark.training.enhancer.subject.resp.IRequestIdProvider;
import com.ovopark.training.enhancer.subject.resp.Result;

public class ResultUtils {
    private static IRequestIdProvider provider;

    public static <T> Result<T> success(T data) {
        return ResultUtils.createResp("", data, true);
    }

    public static <T> Result<T> success() {
        return ResultUtils.createResp("", null, true);
    }

    public static <T> Result<T> fail() {
        return ResultUtils.createResp("fail", null, false);
    }

    public static <T> Result<T> fail(String resultMessage) {
        return ResultUtils.createResp(resultMessage, null, false);
    }

    private static <T> Result<T> createResp(String resultMessage, T data, boolean success) {
        Result<T> r = new Result<T>(resultMessage, data, success);
        if (provider != null) {
            r.setRequestId(provider.getRequestId());
        }
        return r;
    }

    public static void setRequestProvider(IRequestIdProvider provider) {
        ResultUtils.provider = provider;
    }

    public static void main(String[] args) {
        Result<String> result = ResultUtils.createResp("test", "test", true);
        System.out.println("resp = " + JSON.toJSONString(result));
    }
}

