/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.resp;

import com.ovopark.training.enhancer.subject.resp.IRequestIdProvider;
import com.ovopark.training.enhancer.subject.resp.Result;

public class ResultUtils {
    private static IRequestIdProvider provider;

    public static <T> Result<T> success(T data) {
        return ResultUtils.createResp("ok", data, true);
    }

    public static <T> Result<T> success() {
        return ResultUtils.createResp("ok", null, true);
    }

    public static <T> Result<T> fail() {
        return ResultUtils.createResp("error", null, false);
    }

    public static <T> Result<T> fail(String resultMsg) {
        return ResultUtils.createResp(resultMsg, null, false);
    }

    public static <T> Result<T> failData(T data) {
        return ResultUtils.createResp("error", data, false);
    }

    public static <T> Result<T> fail(String resultMsg, T data) {
        return ResultUtils.createResp(resultMsg, data, false);
    }

    public static <T> Result<T> createResp(String resultMsg, T data, boolean success) {
        Result<T> result = new Result<T>(resultMsg, data, success);
        if (provider != null) {
            result.setRequestId(provider.getRequestId());
        }
        return result;
    }

    public static void setRequestProvider(IRequestIdProvider provider) {
        ResultUtils.provider = provider;
    }
}

