
### 使用示例
```java
    public Result<String> foo(@RequestBody Param param) {
        return ResultUtils.fail("系统错误", "data");
        return ResultUtils.success("data");
    }
```

### 套娃注入traceId 和 日志打印
```java
package com.ovopark.training.config;


import com.ovopark.training.enhancer.subject.env.EnvService;
import com.ovopark.training.enhancer.subject.resp.IResultWrapper;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.util.ContextUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;


@Slf4j
@Configuration
public class EnhancerConfig {

    @Autowired
    private EnvService envService;

    @PostConstruct
    public void init(){
        if (envService.isDevelopment()) {
            // 测试环境result注入traceId
            IResultWrapper traceIdWrapper = new IResultWrapper() {
                @Override
                public <T> Result<T> wrap(Result<T> result) {
                    result.setRequestId(ContextUtil.getTraceId());
                    return result;
                }
            };
            IResultWrapper logWrapper = new IResultWrapper() {
                @Override
                public <T> Result<T> wrap(Result<T> result) {
                    log.info("result:{}", result);
                    return traceIdWrapper.wrap(result);
                }
            };

            ResultUtils.setResultWrapper(logWrapper);
        }
    }

}

```