/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.debuginfo;

import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.ctrip.framework.apollo.ConfigService;
import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
import com.ovopark.training.enhancer.subject.resp.DebugFunc;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SqlDebugInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlDebugInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        Long slowSqlTimeMillis = ConfigService.getConfig((String)"training-base").getLongProperty("enhancer.sql.slow-time-millis", Long.valueOf(300L));
        long startTime = System.currentTimeMillis();
        Object response = invocation.proceed();
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        if (cost > slowSqlTimeMillis) {
            log.warn("slow sql " + sql + "\nsql cost" + cost + "ms");
        } else {
            log.info("sql " + sql + "\nsql cost" + cost + "ms");
        }
        if (DebugInfoContext.debugEnable()) {
            DebugFunc debugFunc = new DebugFunc("sql");
            DebugInfoContext.putFunc(debugFunc);
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            String id = mappedStatement.getId();
            int lastDotIndex = id.lastIndexOf(".");
            String methodName = id.substring(lastDotIndex + 1);
            debugFunc.setMethod(methodName);
            List parameterList = (List)boundSql.getParameterObject();
            debugFunc.setParams(parameterList);
            debugFunc.setCostTime(cost);
            debugFunc.setResponse(response);
        }
        return response;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

