package com.ovopark.training.enhancer.subject.env.impl;

import com.ovopark.training.enhancer.subject.env.EnvService;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 *
 */
@Service
public class EnvServiceImpl implements EnvService, EnvironmentAware {

    private static final String ENV_PRODUCTION = "prod";
    private static final Profiles PROFILES_PRODUCTION = Profiles.of(ENV_PRODUCTION);

    @Setter
    private Environment environment;

    @Override
    public boolean isDevelopment() {
        return !isProduction();
    }

    @Override
    public boolean isProduction() {
        return environment.acceptsProfiles(PROFILES_PRODUCTION);
    }

    @Override
    public String get(String production, String develop) {
        return isProduction() ? production : develop;
    }

    @Override
    public String getProfiles() {
        return Arrays.toString(environment.getActiveProfiles());
    }

    public String getActiveProfile() {
        String[] profiles = environment.getActiveProfiles();
        return StringUtils.join(profiles, ",");
    }
}
