/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.aop;

import com.google.common.collect.Maps;
import com.ovopark.training.enhancer.subject.env.EnvService;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ApiAopService {
    private static final Logger log = LoggerFactory.getLogger(ApiAopService.class);
    @Autowired
    private EnvService envService;

    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Object proceed;
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String params = MDC.get((String)"params");
        long startTime = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        this.buildOne(sb, "url", url);
        this.buildOne(sb, "method", method);
        this.buildOne(sb, "uri", uri);
        this.buildOne(sb, "param", params);
        this.buildOne(sb, "userAgent", request.getHeader("User-Agent"));
        this.buildOne(sb, "userId", EhContextUtil.getUserId());
        String invokeInfo = sb.toString();
        log.info(invokeInfo);
        try {
            proceed = pjp.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            long cost = System.currentTimeMillis() - startTime;
            log.info("\u63a5\u53e3\u8017\u65f6 cost {}", (Object)cost);
        }
        return proceed;
    }

    private void buildOne(StringBuilder sb, String key, Object value) {
        sb.append("\n[").append(key).append(":").append(value).append("]");
    }

    private static Map<String, String> buildCookieMap(HttpServletRequest httpServletRequest) {
        HashMap cookieMap = Maps.newHashMap();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.isEmpty((CharSequence)cookie.getValue())) {
                    cookieMap.put(cookie.getName(), cookie.getValue());
                    continue;
                }
                cookieMap.put(cookie.getName(), "");
            }
        }
        return cookieMap;
    }

    public static Map<String, String> extractHeader(HttpServletRequest request) {
        HashMap headerMap = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            if (StringUtils.isEmpty((CharSequence)headerValue)) continue;
            headerMap.put(headerName, headerValue);
        }
        return headerMap;
    }
}

