/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.filter;

import com.alibaba.fastjson.JSON;
import com.ovopark.training.enhancer.filter.ReadBodyRequest;
import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;

@WebFilter(urlPatterns={"/*"})
public class ContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ContextFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String params;
        String requestId;
        Object request = (HttpServletRequest)servletRequest;
        String debug = request.getHeader("debug");
        if ("open".equals(debug)) {
            DebugInfoContext.setDebugEnable(true);
        }
        if ((requestId = request.getHeader("requestId")) == null) {
            requestId = UUID.randomUUID().toString();
        }
        EhContextUtil.setTraceId(requestId);
        MDC.put((String)"traceId", (String)requestId);
        ContentCachingRequestWrapper cacheRequest = new ContentCachingRequestWrapper(request);
        String contentType = request.getContentType();
        if (!StringUtils.isEmpty((Object)contentType) && contentType.contains("application/json")) {
            ReadBodyRequest wrapper = new ReadBodyRequest((HttpServletRequest)request);
            params = wrapper.getBody();
            params = StringUtils.isEmpty((Object)params) ? JSON.toJSONString((Object)request.getParameterMap()) : params;
            request = wrapper;
        } else {
            params = JSON.toJSONString((Object)request.getParameterMap());
        }
        MDC.put((String)"params", (String)params);
        String userAgent = request.getHeader("User-Agent");
        EhContextUtil.setUserAgent(userAgent);
        EhContextUtil.setRequest((ServletRequest)request);
        filterChain.doFilter((ServletRequest)request, servletResponse);
    }
}

