/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.aop;

import com.ovopark.training.enhancer.subject.debuginfo.DebugFunc;
import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
import com.ovopark.training.enhancer.subject.env.EnvService;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAopService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAopService.class);
    @Autowired
    private EnvService envService;

    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        if (!DebugInfoContext.debugEnable("func")) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        DebugFunc debugFunc = new DebugFunc("func");
        DebugInfoContext.putFunc(debugFunc);
        long startTime = System.currentTimeMillis();
        Object proceed = pjp.proceed();
        debugFunc.setCostTime(System.currentTimeMillis() - startTime);
        debugFunc.setMethod(pjp.getSignature().getName());
        debugFunc.setResponse(proceed);
        debugFunc.setParams(Arrays.asList(args));
        return proceed;
    }
}

