/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.env.impl;

import com.ovopark.training.enhancer.subject.env.EnvService;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Service;

@Service
public class EnvServiceImpl
implements EnvService,
EnvironmentAware {
    private static final String ENV_PRODUCTION = "prod";
    private static final Profiles PROFILES_PRODUCTION = Profiles.of((String[])new String[]{"prod"});
    private Environment environment;

    @Override
    public boolean isDevelopment() {
        return !this.isProduction();
    }

    @Override
    public boolean isProduction() {
        return this.environment.acceptsProfiles(PROFILES_PRODUCTION);
    }

    @Override
    public String get(String production, String develop) {
        return this.isProduction() ? production : develop;
    }

    @Override
    public String getProfiles() {
        return Arrays.toString(this.environment.getActiveProfiles());
    }

    public String getActiveProfile() {
        Object[] profiles = this.environment.getActiveProfiles();
        return StringUtils.join((Object[])profiles, (String)",");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

