/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.aop;

import com.ovopark.training.enhancer.subject.debuginfo.DebugFunc;
import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
import com.ovopark.training.enhancer.subject.env.EnvService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceAopService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAopService.class);
    @Autowired
    private EnvService envService;

    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        List<String> funcBlackKeys;
        if (!DebugInfoContext.debugEnable("func")) {
            return pjp.proceed();
        }
        String signature = pjp.getSignature().toLongString();
        List<String> funcWhiteKeys = DebugInfoContext.getFuncWhiteKeys();
        if (funcWhiteKeys != null) {
            for (String string : funcWhiteKeys) {
                if (StringUtils.contains((CharSequence)signature, (CharSequence)string)) break;
            }
        }
        if ((funcBlackKeys = DebugInfoContext.getFuncBlackKeys()) != null) {
            for (String funcBlackKey : funcBlackKeys) {
                if (!StringUtils.contains((CharSequence)signature, (CharSequence)funcBlackKey)) continue;
                return pjp.proceed();
            }
        }
        Object[] objectArray = pjp.getArgs();
        DebugFunc debugFunc = new DebugFunc("func");
        DebugInfoContext.putFunc(debugFunc);
        long startTime = System.currentTimeMillis();
        Object proceed = pjp.proceed();
        debugFunc.setCostTime(System.currentTimeMillis() - startTime);
        debugFunc.setMethod(signature);
        debugFunc.setResponse(proceed);
        debugFunc.setParams(Arrays.asList(objectArray));
        return proceed;
    }
}

