package com.ovopark.training.enhancer.filter;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.*;

public class ReadBodyRequest extends HttpServletRequestWrapper {
  private final String body;

  public String getBody() {
    return body;
  }

  /**
   * 取出请求体body中的参数（创建对象时执行）
   *
   * @param request
   */
  public ReadBodyRequest(HttpServletRequest request) throws IOException {
    super(request);
    StringBuilder sb = new StringBuilder();
    InputStream ins = request.getInputStream();
    BufferedReader isr = null;
    try {
      if (ins != null) {
        isr = new BufferedReader(new InputStreamReader(ins));
        char[] charBuffer = new char[128];
        int readCount = 0;
        while ((readCount = isr.read(charBuffer)) != -1) {
          sb.append(charBuffer, 0, readCount);
        }
      } else {
        sb.append("");
      }
    } catch (IOException e) {
      throw e;
    } finally {
      if (isr != null) {
        isr.close();
      }
    }
    sb.toString();
    body = sb.toString();
  }

  @Override
  public BufferedReader getReader() throws IOException {
    return new BufferedReader(new InputStreamReader(this.getInputStream()));
  }

  @Override
  public ServletInputStream getInputStream() throws IOException {
    final ByteArrayInputStream byteArrayIns = new ByteArrayInputStream(body.getBytes());
    ServletInputStream servletIns = new ServletInputStream() {
      @Override
      public boolean isFinished() {
        return false;
      }

      @Override
      public boolean isReady() {
        return false;
      }

      @Override
      public void setReadListener(ReadListener readListener) {
      }

      @Override
      public int read() throws IOException {
        return byteArrayIns.read();
      }
    };
    return servletIns;
  }
}