//package com.ovopark.training.enhancer.subject.debuginfo;
//
//import com.ctrip.framework.apollo.ConfigService;
//import com.ovopark.training.enhancer.constant.EnhancerConst;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.ibatis.executor.parameter.ParameterHandler;
//import org.apache.ibatis.executor.statement.StatementHandler;
//import org.apache.ibatis.mapping.BoundSql;
//import org.apache.ibatis.mapping.MappedStatement;
//import org.apache.ibatis.plugin.*;
//
//import java.sql.Connection;
//import java.util.List;
//import java.util.Properties;
//
//@Slf4j
//@Intercepts({@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})})
//public class SqlDebugInterceptor implements Interceptor {
//
//    @Override
//    public Object intercept(Invocation invocation) throws Throwable {
//        StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
//        BoundSql boundSql = statementHandler.getBoundSql();
//        String sql = boundSql.getSql();
//
//        Long slowSqlTimeMillis = ConfigService
//                .getConfig(EnhancerConst.ConfigNamespace.defaultNamespace)
//                .getLongProperty("enhancer.sql.slow-time-millis", 300L);
//        long startTime = System.currentTimeMillis();
//
//        // 执行sql
//        Object response = invocation.proceed();
//
//        long endTime = System.currentTimeMillis();
//        long cost = endTime - startTime;
//        if(cost > slowSqlTimeMillis) {
//            log.warn("slow sql " + sql + "\nsql cost" + cost + "ms");
//        } else {
//            log.info("sql " + sql + "\nsql cost" + cost + "ms");
//        }
//
//        // 采集 debug info
//        if (DebugInfoContext.debugEnable()) {
//            DebugFunc debugFunc = new DebugFunc(DebugInfo.Type.sql);
//            DebugInfoContext.putFunc(debugFunc);
//
////            ParameterHandler parameterHandler = statementHandler.getParameterHandler();
////            Object parameterObject = parameterHandler.getParameterObject();
////            String methodName = invocation.getMethod().getName();
////            MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
////            String id = mappedStatement.getId();
////            int lastDotIndex = id.lastIndexOf(".");
////            String methodName = id.substring(lastDotIndex + 1);
////            debugFunc.setMethod(methodName);
//
//            // 获取 SQL 的入参
////        Object parameterObject = invocation.getArgs()[1];
////        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
////            List<Object> parameterList = (List<Object>) boundSql.getParameterObject();
////            List<Object> parameterList = (List<Object>) statementHandler.getParameterHandler().getParameterObject();
////            debugFunc.setParams(parameterList);
////            debugFunc.setCostTime(cost);
////            debugFunc.setResponse(response);
//        }
//        return response;
//    }
//
//    @Override
//    public Object plugin(Object target) {
//        return Plugin.wrap(target, this);
//    }
//
//    @Override
//    public void setProperties(Properties properties) {
//        // 可以在此处理配置属性，如果有的话
//    }
//}
//
