package com.ovopark.training.enhancer.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public class HttpUtils {

    public static String getRemoteIp(HttpServletRequest request) {
        String realIp = request.getHeader("X-Real-IP");
        String remoteIp = request.getHeader("x-forwarded-for"); // nginx反向代理
        if (StringUtils.isNotEmpty(realIp)) {
            log.debug("X-Real-IP:" + realIp);
        }
        if (StringUtils.isNotEmpty(remoteIp)) {
            log.debug("x-forwarded-for:" + remoteIp);
            // 截取第一个
            // TODO 这里无法防止伪造x-forwarded-for，要防止伪造需要配置第一台nginx的ip。取ip前面的一个地址
            if (remoteIp.contains(",")) {
                remoteIp = remoteIp.split(",")[0].trim();
            }
            return remoteIp;
        } else {
            return request.getRemoteAddr();
        }
    }
}
