/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=110)
public class EhLogFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(EhLogFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        long startTime = System.currentTimeMillis();
        String params = MDC.get((String)"params");
        StringBuilder sb = new StringBuilder();
        this.buildOne(sb, "url", url);
        this.buildOne(sb, "method", method);
        this.buildOne(sb, "uri", uri);
        this.buildOne(sb, "param", params);
        this.buildOne(sb, "userAgent", request.getHeader("User-Agent"));
        this.buildOne(sb, "enterpriseId", EhContextUtil.getEnterpriseId());
        this.buildOne(sb, "userId", EhContextUtil.getUserId());
        String invokeInfo = sb.toString();
        log.info(invokeInfo);
        Map<String, String> headerMap = EhLogFilter.extractHeader(request);
        log.info("header:{}", (Object)JSON.toJSONString(headerMap));
        Map<String, String> cookieMap = EhLogFilter.buildCookieMap(request);
        log.info("cookie:{}", (Object)JSON.toJSONString(cookieMap));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        long cost = System.currentTimeMillis() - startTime;
        log.info("\u63a5\u53e3\u8017\u65f6 cost {}", (Object)cost);
    }

    private void buildOne(StringBuilder sb, String key, Object value) {
        sb.append("\n[").append(key).append(":").append(value).append("]");
    }

    private static Map<String, String> buildCookieMap(HttpServletRequest httpServletRequest) {
        HashMap cookieMap = Maps.newHashMap();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.isEmpty((CharSequence)cookie.getValue())) {
                    cookieMap.put(cookie.getName(), cookie.getValue());
                    continue;
                }
                cookieMap.put(cookie.getName(), "");
            }
        }
        return cookieMap;
    }

    public static Map<String, String> extractHeader(HttpServletRequest request) {
        HashMap headerMap = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            if (StringUtils.isEmpty((CharSequence)headerValue)) continue;
            headerMap.put(headerName, headerValue);
        }
        return headerMap;
    }
}

