package com.ovopark.training.enhancer.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import com.ovopark.training.enhancer.utils.HttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;

@Slf4j
@Order(100)
public class EhContextFilter extends OncePerRequestFilter {

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        //如果有上层调用就用上层的ID
        String requestId = request.getHeader("requestId");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        EhContextUtil.setTraceId(requestId);
        MDC.put("traceId", requestId);

        String remoteIp = HttpUtils.getRemoteIp(request);
        MDC.put("requestIp", remoteIp);

        ContentCachingRequestWrapper cacheRequest = new ContentCachingRequestWrapper(request);
        EhContextUtil.setRequest(cacheRequest);
        String contentType = request.getContentType();
        String params;
        if (!StringUtils.isEmpty(contentType) && contentType.contains("application/json")) {
            byte[] body = cacheRequest.getContentAsByteArray();
            params = new String(body);
            params = StringUtils.isEmpty(params) ? JSON.toJSONString(request.getParameterMap()) : params;
            request = cacheRequest;
        } else {
            params = JSON.toJSONString(request.getParameterMap());
        }
        MDC.put("params", params);

        String userAgent = request.getHeader("User-Agent");
        EhContextUtil.setUserAgent(userAgent);

        filterChain.doFilter(cacheRequest, response);
    }

}
