package com.ovopark.training.enhancer.subject.alarm;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.awt.image.BufferedImage;
import java.io.IOException;

@Slf4j
public class WeiXinAlarmFacade implements IAlarmFacade {
    private static final String WEB_HOOK_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";

    private WeiXinAlarmFacade() {
    }

    public static WeiXinAlarmFacade getInstance() {
        return Holder.sInstance;
    }

    public void sentText(String key, String content, String title, String[] names) {
        sent(key, content, AlarmEnum.text, names, null);
    }

    public void sentMarkDown(String key, String content, String title, String[] names) {
        sent(key, content, AlarmEnum.markdown, null, null);
    }

    public void sentImage(String key, BufferedImage bufferedImage) {
        sent(key, bufferedImage);
    }

    private static void sent(String key, String content, AlarmEnum type, String[] mentioned_list, String[] mentioned_mobile_list) {
        String url = WEB_HOOK_URL + key;
        AlarmInfo alarmText = new AlarmInfo();
        if (type != null) {
            alarmText.setMsgtype(type.toString());
        }

        switch (type) {
            case text:
                Text text = new Text();
                text.setContent(content);
                if (mentioned_list != null && mentioned_list.length > 0) {
                    text.setMentioned_list(mentioned_list);
                }

                if (mentioned_mobile_list != null && mentioned_mobile_list.length > 0) {
                    text.setMentioned_mobile_list(mentioned_mobile_list);
                }

                alarmText.setText(text);
                break;
            case markdown:
                MarkDown markDown = new MarkDown();
                markDown.setContent(content);
                alarmText.setMarkdown(markDown);
        }

        String json = JSONObject.toJSONString(alarmText);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity<String> entity = new HttpEntity(json, headers);
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, entity, String.class);
        String body = responseEntity.getBody();
        log.info("返回结果:{}", body);
    }

    private static void sent(String key, BufferedImage bufferedImage) {
        String url = WEB_HOOK_URL + key;
        AlarmInfo alarmText = new AlarmInfo();
        alarmText.setMsgtype(AlarmEnum.image.toString());

        Image image;
        try {
            image = new Image(bufferedImage);
        } catch (IOException e) {
            log.error("图片转换失败", e);
            return;
        }

        alarmText.setImage(image);
        String json = JSONObject.toJSONString(alarmText);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity(json, headers);
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, entity, String.class);
        String body = responseEntity.getBody();
        log.info("返回结果:{}", body);
    }

    private static class Holder {
        private static final WeiXinAlarmFacade sInstance = new WeiXinAlarmFacade();
    }
}
