package com.ovopark.training.enhancer.subject.resp;

import com.ovopark.training.enhancer.subject.debuginfo.DebugInfo;
import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;

/**
 *
 */
public class ResultUtils {

    private static IResultWrapper resultWrapper;

    public static <T> Result<T> success(T data) {
        return createResp(ResultConst.Result.ok, data, true);
    }

    public static <T> Result<T> success() {
        return createResp(ResultConst.Result.ok, null, true);
    }

    public static <T> Result<T> fail() {
        return createResp(ResultConst.Result.error, null, false);
    }

    public static <T> Result<T> fail(String resultMsg) {
        return createResp(resultMsg, null, false);
    }

    public static <T> Result<T> failData(T data) {
        return createResp(ResultConst.Result.error, data, false);
    }

    public static <T> Result<T> fail(String resultMsg, T data) {
        return createResp(resultMsg, data, false);
    }

    public static <T> Result<T> createResp(String resultMsg, T data, boolean success) {
        Result<T> result = new Result<>(resultMsg, data, success);

        if (resultWrapper != null) {
            return resultWrapper.wrap(result);
        }
        return result;
    }

    public static void setResultWrapper(IResultWrapper wrapper) {
        ResultUtils.resultWrapper = wrapper;
    }

    public static <T> boolean isSuccessAndNotNullData(IResult<T> result) {
        if (result == null) {
            return false;
        }
        if(result.getData() == null){
            return false;
        }
        return result.isSuccess();
    }

}
