/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.filter;

import com.ovopark.training.enhancer.filter.EhAbstractRequestLoggingFilter;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.StringUtils;

@Order(value=110)
public class EhLogFilter
extends EhAbstractRequestLoggingFilter {
    private static final Logger log = LoggerFactory.getLogger(EhLogFilter.class);

    @Override
    protected void beforeRequest(HttpServletRequest request, String message) {
        EhContextUtil.setStartTime(System.currentTimeMillis());
        log.info("ehBeforeRequest|" + message);
    }

    @Override
    protected void afterRequest(HttpServletRequest request, String message) {
        StringBuilder sb = new StringBuilder(message);
        long cost = System.currentTimeMillis() - EhContextUtil.getStartTime();
        this.buildOne(sb, "cost", cost);
        log.info("ehRequest|" + sb);
    }

    @Override
    public String createMessage(HttpServletRequest request, String prefix, String suffix) {
        String payload;
        String queryString;
        StringBuilder msg = new StringBuilder();
        msg.append("uri").append("=").append(request.getRequestURI());
        this.buildOne(msg, "method", request.getMethod());
        if (this.isIncludeQueryString() && (queryString = request.getQueryString()) != null) {
            this.buildOne(msg, "queryString", queryString);
        }
        this.buildOne(msg, "userId", EhContextUtil.getUserId());
        this.buildOne(msg, "enterpriseId", EhContextUtil.getEnterpriseId());
        if (this.isIncludeClientInfo()) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                this.buildOne(msg, "client", client);
            }
            if ((session = request.getSession(false)) != null) {
                this.buildOne(msg, "session", session.getId());
            }
            if ((user = request.getRemoteUser()) != null) {
                this.buildOne(msg, "user", user);
            }
        }
        if (this.isIncludeHeaders()) {
            this.buildOne(msg, "headers", new ServletServerHttpRequest(request).getHeaders());
        }
        if (this.isIncludePayload() && (payload = this.getMessagePayload(request)) != null) {
            this.buildOne(msg, "payload", payload);
        }
        return msg.toString();
    }

    private String wrap(String message) {
        return "ehRequest|" + message;
    }

    private void buildOne(StringBuilder sb, String key, Object value) {
        sb.append("##").append(key).append("=").append(value);
    }
}

