/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.config;

import com.ovopark.training.enhancer.filter.EhClearFilter;
import com.ovopark.training.enhancer.filter.EhContextFilter;
import com.ovopark.training.enhancer.filter.EhLogFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@Configuration
@ConditionalOnProperty(name={"enhancer.enable"}, havingValue="true", matchIfMissing=true)
public class EhConfigurations {
    @Bean
    @ConditionalOnProperty(name={"enhancer.eh-context-filter.enable"}, havingValue="true", matchIfMissing=true)
    public EhContextFilter ehContextFilter() {
        return new EhContextFilter();
    }

    @Bean
    @ConditionalOnProperty(name={"enhancer.eh-log-filter.enable"}, havingValue="true", matchIfMissing=true)
    public EhLogFilter ehLogFilter() {
        EhLogFilter ehLogFilter = new EhLogFilter();
        ehLogFilter.setIncludeHeaders(true);
        ehLogFilter.setIncludeQueryString(true);
        ehLogFilter.setIncludePayload(true);
        ehLogFilter.setIncludeHeaders(true);
        ehLogFilter.setIncludeClientInfo(true);
        ehLogFilter.setMaxPayloadLength(1000);
        return ehLogFilter;
    }

    @ConditionalOnProperty(name={"enhancer.commons-request-logging-filter.enable"}, havingValue="true", matchIfMissing=false)
    @Bean
    public CommonsRequestLoggingFilter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setIncludeHeaders(true);
        filter.setIncludeClientInfo(true);
        filter.setAfterMessagePrefix("REQUEST DATA-");
        return filter;
    }

    @Bean
    @ConditionalOnProperty(name={"enhancer.eh-clear-filter.enable"}, havingValue="true", matchIfMissing=true)
    public EhClearFilter ehClearFilter() {
        return new EhClearFilter();
    }
}

