/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.datasource;

import com.ovopark.training.enhancer.subject.datasource.DataSource;
import com.ovopark.training.enhancer.subject.datasource.RoutingDataSourceContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=1)
@Aspect
public class DataSourceAspect {
    private static final Logger log = LoggerFactory.getLogger(DataSourceAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(dataSource)")
    public Object routingWithDataSource(ProceedingJoinPoint joinPoint, DataSource dataSource) throws Throwable {
        try {
            RoutingDataSourceContext.setDataSourceRoutingKey(dataSource.value());
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            RoutingDataSourceContext.clear();
        }
    }
}

