/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.datasource;

import com.ovopark.training.enhancer.subject.datasource.DataSourceAspect;
import com.ovopark.training.enhancer.subject.datasource.DynamicDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class DynamicDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceConfig.class);

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public DynamicDataSource primaryDataSource(Map<String, DataSource> dataSourceMap, @Value(value="${dynamic-datasource.default:master}") String defaultDataSource) {
        DynamicDataSource routing = new DynamicDataSource();
        routing.setTargetDataSources(new HashMap<String, DataSource>(dataSourceMap));
        routing.setDefaultTargetDataSource(dataSourceMap.get(defaultDataSource));
        return routing;
    }

    @Bean
    public DataSourceAspect dataSourceAspect() {
        return new DataSourceAspect();
    }
}

