/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.strategyfactory;

import com.ovopark.training.enhancer.subject.strategyfactory.BaseStrategy;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HandlerFactory<E, T extends BaseStrategy<E>>
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(HandlerFactory.class);
    private static final String TAG = " handlerFactory ";
    private ApplicationContext applicationContext;
    private final Class<T> strategyInterfaceType;
    private Map<E, T> mStrategyMap;

    public HandlerFactory(Class<T> strategyInterfaceType) {
        this.strategyInterfaceType = strategyInterfaceType;
    }

    public T getStrategy(E type) {
        return (T)((BaseStrategy)this.mStrategyMap.get(type));
    }

    public void afterPropertiesSet() {
        Map beansOfType = this.applicationContext.getBeansOfType(this.strategyInterfaceType);
        log.info("{} \u7b56\u7565\u5de5\u5382\u521d\u59cb\u5316\u5f00\u59cb beans {}", (Object)TAG, (Object)beansOfType);
        this.mStrategyMap = beansOfType.values().stream().filter(strategy -> StringUtils.isNotEmpty((CharSequence)strategy.getType().toString())).collect(Collectors.toMap(BaseStrategy::getType, Function.identity()));
        log.info("{} \u7b56\u7565\u5de5\u5382\u521d\u59cb\u5316\u7ed3\u675f beansMap {}", (Object)TAG, this.mStrategyMap);
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

