package com.ovopark.training.enhancer.subject.gracefulshutdown;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;

@EnableAutoConfiguration
public class GracefulHealth implements HealthIndicator {
    @Autowired
    private GracefulShutdownEndpoint gracefulShutdownEndpoint;

    public GracefulHealth() {
    }

    public Health health() {
        return this.gracefulShutdownEndpoint.getStartShutdown() == null ? Health.up().build() : Health.outOfService().build();
    }
}
