package com.ovopark.training.enhancer.subject.gracefulshutdown.shutdown;

import com.ovopark.training.enhancer.subject.gracefulshutdown.OrderedShutdown;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;

@Slf4j
public class KafkaShutdown implements OrderedShutdown {

    @Autowired
    private KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry;

    public KafkaShutdown() {
    }

    public void pause() throws InterruptedException {
    }

    public void shutdown(Integer delay) throws InterruptedException {
        if (kafkaListenerEndpointRegistry != null) {
            kafkaListenerEndpointRegistry.stop(() -> log.info("Kafka listeners stopped."));
            log.info("Stopping Kafka listeners...");
        } else {
            log.info("No Kafka listeners to stop.");
        }
    }

    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 1;
    }

}
