/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.datasource;

import com.ovopark.training.enhancer.subject.datasource.RoutingDataSource;
import com.ovopark.training.enhancer.subject.datasource.RoutingDataSourceAspect;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(name={"routing-datasource.enable"}, havingValue="true", matchIfMissing=false)
public class RoutingDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(RoutingDataSourceConfig.class);

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public RoutingDataSource primaryDataSource(Map<String, DataSource> dataSourceMap, @Value(value="${routing-datasource.default:master}") String defaultDataSource) {
        RoutingDataSource routing = new RoutingDataSource();
        routing.setTargetDataSources(new HashMap<String, DataSource>(dataSourceMap));
        routing.setDefaultTargetDataSource(dataSourceMap.get(defaultDataSource));
        return routing;
    }

    @Bean
    public RoutingDataSourceAspect dataSourceAspect() {
        return new RoutingDataSourceAspect();
    }
}

