/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.utils;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class EhContextUtil {
    private static final Logger log = LoggerFactory.getLogger(EhContextUtil.class);
    private static final ThreadLocal<HashMap<String, Object>> envStore = ThreadLocal.withInitial(HashMap::new);

    public static void clear() {
        EhContextUtil.singleClear();
        MDC.clear();
    }

    public static void singleClear() {
        envStore.get().clear();
        envStore.remove();
    }

    public static void remove(String contextKey) {
        envStore.get().remove(contextKey);
    }

    public static void putAll(HashMap<String, Object> keyValue) {
        envStore.get().putAll(keyValue);
    }

    public static HashMap<String, Object> getAll() {
        return new HashMap<String, Object>((Map)envStore.get());
    }

    public static void put(String key, Object value) {
        envStore.get().put(key, value);
    }

    public static Object get(String key) {
        return envStore.get().get(key);
    }

    public static void setRequest(HttpServletRequest servletRequest) {
        EhContextUtil.put("request", servletRequest);
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)EhContextUtil.get("request");
    }

    public static void setClientIp(String ip) {
        EhContextUtil.put("clientIp", ip);
    }

    public static String getClientIp() {
        return (String)EhContextUtil.get("clientIp");
    }

    public static void setUserAgent(String userAgent) {
        EhContextUtil.put("userAgent", userAgent);
    }

    public static String getUserAgent() {
        return (String)EhContextUtil.get("userAgent");
    }

    public static void setUserId(int userId) {
        log.debug("setUserId:{}", (Object)userId);
        EhContextUtil.put("userId", userId);
    }

    public static int getUserId() {
        Integer userId = (Integer)EhContextUtil.get("userId");
        return userId == null ? 0 : userId;
    }

    public static void setTraceId(String requestId) {
        MDC.put((String)"traceId", (String)requestId);
        MDC.put((String)"requestId", (String)requestId);
    }

    public static String getTraceId() {
        return MDC.get((String)"requestId");
    }

    public static void setEnterpriseId(Integer enterpriseId) {
        EhContextUtil.put("enterpriseId", enterpriseId);
    }

    public static Integer getEnterpriseId() {
        return (Integer)EhContextUtil.get("enterpriseId");
    }

    public static void setStartTime(Long startTime) {
        EhContextUtil.put("startTime", startTime);
    }

    public static Long getStartTime() {
        return (Long)EhContextUtil.get("startTime");
    }
}

