//package com.ovopark.training.enhancer.aop;
//
//import com.ovopark.training.enhancer.subject.debuginfo.DebugFunc;
//import com.ovopark.training.enhancer.subject.debuginfo.DebugInfo;
//import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
//import com.ovopark.training.enhancer.subject.env.EnvService;
//import com.ovopark.training.enhancer.subject.resp.Result;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.Signature;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.Arrays;
//import java.util.List;
//
///**
// *
// */
//@Slf4j
//@Service
//public class ServiceAopService {
//
//    @Autowired
//    private EnvService envService;
//
//    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
//        if (!DebugInfoContext.debugEnable(DebugInfoContext.MODEL_FUNC)) {
//            return pjp.proceed();
//        }
//        String signature = pjp.getSignature().toShortString();
//        List<String> funcWhiteKeys = DebugInfoContext.getFuncWhiteKeys();
//        if (funcWhiteKeys != null) {
//            for (String funcWhiteKey : funcWhiteKeys) {
//                if (StringUtils.contains(signature, funcWhiteKey)) {
//                    break;
//                }
//            }
//        }
//
//        List<String> funcBlackKeys = DebugInfoContext.getFuncBlackKeys();
//        if (funcBlackKeys != null) {
//            for (String funcBlackKey : funcBlackKeys) {
//                if (StringUtils.contains(signature, funcBlackKey)) {
//                    return pjp.proceed();
//                }
//            }
//        }
//
//        Object[] args = pjp.getArgs();
//        DebugFunc debugFunc = new DebugFunc(DebugInfo.Type.func);
//        DebugInfoContext.putFunc(debugFunc);
//
//        long startTime = System.currentTimeMillis();
//
//        Object proceed = pjp.proceed();
//
//        debugFunc.setCostTime(System.currentTimeMillis() - startTime);
//        debugFunc.setMethod(signature);
//        if (!(proceed instanceof Result)) {
//            debugFunc.setResponse(proceed);
//        }
//        debugFunc.setParams(Arrays.asList(args));
//        return proceed;
//    }
//
//}
