package com.ovopark.training.enhancer.filter;

import com.alibaba.arms.tracing.Span;
import com.alibaba.arms.tracing.Tracer;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import com.ovopark.training.enhancer.utils.HttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;

@Slf4j
@Order(100)
public class EhContextFilter extends OncePerRequestFilter {

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        //如果有上层调用就用上层的ID
        String requestId = request.getHeader("requestId");
        Span span = Tracer.builder().getSpan();
        String traceId = span.getTraceId();
        if (traceId != null && !traceId.isEmpty()) {
            requestId = traceId;
        }
        if (requestId == null || requestId.isEmpty()) {
            requestId = UUID.randomUUID().toString();
        }

        EhContextUtil.setTraceId(requestId);

        String remoteIp = HttpUtils.getRemoteIp(request);
        MDC.put("requestIp", remoteIp);

        EhContextUtil.setRequest(request);

        String userAgent = request.getHeader("User-Agent");
        EhContextUtil.setUserAgent(userAgent);

        filterChain.doFilter(request, response);
    }

}
