package com.ovopark.training.enhancer.subject.datasource;

import com.ovopark.training.enhancer.subject.datasource.anno.DataSourceRouting;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;

@Order(1)
@Aspect
@Slf4j
public class RoutingDataSourceAspect {

    @Around("@annotation(dataSourceRouting)")
    public Object routingWithDataSource(ProceedingJoinPoint joinPoint, DataSourceRouting dataSourceRouting) throws Throwable {
        try {
            log.debug("Set DataSource: {}", dataSourceRouting.value());
            RoutingDataSourceContext.setDataSourceRoutingKey(dataSourceRouting.value());
            return joinPoint.proceed();
        } finally {
            log.debug("Clear DataSource");
            RoutingDataSourceContext.clear();
        }
    }

}
