/*
 * Decompiled with CFR 0.152.
 */
package netpay.merchant.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import netpay.merchant.crypto.RSA;

public class MD5withRSA
extends Signature {
    private MessageDigest md5Digest;
    private RSA rsaCipher;
    private static final SecureRandom rand = new SecureRandom();
    private static final byte[] md5DigestInfo = new byte[]{48, 32};
    private static final byte[] md5Identifier = new byte[]{48, 12};
    private static final byte[] id_md5 = new byte[]{6, 8, 42, -122, 72, -122, -9, 13, 2, 5};
    private static final byte[] NULL = new byte[]{5, 0};
    private static final byte[] digestHdr = new byte[]{4, 16};

    public MD5withRSA() {
        super("MD5withRSA");
        try {
            this.md5Digest = MessageDigest.getInstance("MD5", "ABA");
            this.rsaCipher = new RSA();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private byte[] encodeDigest(byte[] abyte0) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        bytearrayoutputstream.write(md5DigestInfo);
        bytearrayoutputstream.write(md5Identifier);
        bytearrayoutputstream.write(id_md5);
        bytearrayoutputstream.write(NULL);
        bytearrayoutputstream.write(digestHdr);
        bytearrayoutputstream.write(abyte0);
        return bytearrayoutputstream.toByteArray();
    }

    protected Object engineGetParameter(String s) throws InvalidParameterException {
        throw new InvalidParameterException("The parameter " + s + " is invalid for this algorithm.");
    }

    protected void engineInitSign(PrivateKey privatekey) throws InvalidKeyException {
        this.md5Digest.reset();
        this.rsaCipher.engineInit(1, privatekey, rand);
    }

    protected void engineInitVerify(PublicKey publickey) throws InvalidKeyException {
        this.md5Digest.reset();
        this.rsaCipher.engineInit(2, publickey, rand);
    }

    protected void engineSetParameter(String s, Object obj) throws InvalidParameterException {
        throw new InvalidParameterException("The parameter " + s + " is invalid for this algorithm.");
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] abyte0 = this.md5Digest.digest();
        try {
            byte[] abyte1 = this.encodeDigest(abyte0);
            byte[] abyte2 = this.rsaCipher.engineDoFinal(abyte1, 0, abyte1.length);
            return abyte2;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    protected void engineUpdate(byte byte0) throws SignatureException {
        this.md5Digest.update(byte0);
    }

    protected void engineUpdate(byte[] abyte0, int i, int j) throws SignatureException {
        this.md5Digest.update(abyte0, i, j);
    }

    protected boolean engineVerify(byte[] abyte0) throws SignatureException {
        byte[] abyte1 = this.md5Digest.digest();
        try {
            byte[] abyte2 = this.rsaCipher.engineDoFinal(abyte0, 0, abyte0.length);
            byte[] abyte3 = this.encodeDigest(abyte1);
            if (abyte2.length != abyte3.length) {
                return false;
            }
            for (int i = 0; i < abyte2.length; ++i) {
                if (abyte2[i] == abyte3[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }
}

