/*
 * Decompiled with CFR 0.152.
 */
package netpay.merchant.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import netpay.merchant.crypto.BlockCipher;

public class RSA
extends BlockCipher {
    public static final String ident = "$Id: RSA.java,v 1.25 1999/01/22 06:28:03 leachbj Exp $";
    private static final int HEADER_SIZE = 11;
    private RSAPublicKey rsaPublicKey;
    private RSAPrivateKey rsaPrivateKey;
    private int significantBytes = 11;
    private boolean padded = true;
    private static final int BITS_IN_BYTE = 8;

    public RSA() {
        this.paddedStream = false;
    }

    private BigInteger crtProcess(BigInteger biginteger) {
        BigInteger biginteger8;
        RSAPrivateCrtKey rsaprivatecrtkey = (RSAPrivateCrtKey)this.rsaPrivateKey;
        BigInteger biginteger1 = rsaprivatecrtkey.getPrivateExponent();
        BigInteger biginteger2 = rsaprivatecrtkey.getPrimeP();
        BigInteger biginteger3 = rsaprivatecrtkey.getPrimeQ();
        BigInteger biginteger4 = rsaprivatecrtkey.getPrimeExponentP();
        BigInteger biginteger5 = rsaprivatecrtkey.getPrimeExponentQ();
        BigInteger biginteger6 = rsaprivatecrtkey.getCrtCoefficient();
        BigInteger biginteger7 = biginteger.remainder(biginteger2).modPow(biginteger4, biginteger2);
        BigInteger biginteger9 = biginteger7.compareTo(biginteger8 = biginteger.remainder(biginteger3).modPow(biginteger5, biginteger3)) >= 0 ? biginteger7.subtract(biginteger8) : biginteger2.subtract(biginteger8.subtract(biginteger7));
        biginteger9 = biginteger9.multiply(biginteger6);
        biginteger9 = biginteger9.remainder(biginteger2);
        biginteger9 = biginteger9.multiply(biginteger3);
        biginteger9 = biginteger9.add(biginteger8);
        return biginteger9;
    }

    private BigInteger decrypt(BigInteger biginteger) {
        if (this.rsaPrivateKey instanceof RSAPrivateCrtKey) {
            return this.crtProcess(biginteger);
        }
        BigInteger biginteger1 = null;
        BigInteger biginteger2 = null;
        if (this.rsaPrivateKey != null) {
            biginteger1 = this.rsaPrivateKey.getPrivateExponent();
            biginteger2 = this.rsaPrivateKey.getModulus();
        } else {
            biginteger1 = this.rsaPublicKey.getPublicExponent();
            biginteger2 = this.rsaPublicKey.getModulus();
        }
        return biginteger.modPow(biginteger1, biginteger2);
    }

    private byte[] decrypt(byte[] abyte0) {
        BigInteger biginteger = new BigInteger(1, abyte0);
        biginteger = this.decrypt(biginteger);
        return biginteger.toByteArray();
    }

    protected final int decryptBlock(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws BadPaddingException {
        int i1;
        byte[] abyte2 = new byte[this.significantBytes];
        System.arraycopy(abyte0, i, abyte2, 0, abyte2.length);
        byte[] abyte3 = this.decrypt(abyte2);
        int l = 0;
        if (this.padded) {
            if (abyte3[0] != 1 && abyte3[0] != 2) {
                throw new BadPaddingException("Bad block type");
            }
            for (l = 1; l != abyte3.length && abyte3[l] != 0; ++l) {
            }
            ++l;
        }
        if ((i1 = abyte3.length - l) <= 0 || i1 > this.significantBytes - 11) {
            throw new BadPaddingException("Invalid PKCS1 block");
        }
        System.arraycopy(abyte3, l, abyte1, k, i1);
        return i1;
    }

    protected BigInteger encrypt(BigInteger biginteger) {
        if (this.rsaPrivateKey instanceof RSAPrivateCrtKey) {
            return this.crtProcess(biginteger);
        }
        BigInteger biginteger1 = null;
        BigInteger biginteger2 = null;
        if (this.rsaPrivateKey != null) {
            biginteger1 = this.rsaPrivateKey.getPrivateExponent();
            biginteger2 = this.rsaPrivateKey.getModulus();
        } else {
            biginteger1 = this.rsaPublicKey.getPublicExponent();
            biginteger2 = this.rsaPublicKey.getModulus();
        }
        return biginteger.modPow(biginteger1, biginteger2);
    }

    private byte[] encrypt(byte[] abyte0) {
        BigInteger biginteger = new BigInteger(1, abyte0);
        biginteger = this.encrypt(biginteger);
        return biginteger.toByteArray();
    }

    protected final int encryptBlock(byte[] abyte0, int i, int j, byte[] abyte1, int k) throws IllegalBlockSizeException {
        if (j > this.significantBytes - 11) {
            throw new IllegalBlockSizeException("Datasize greater than allowable payload size.");
        }
        byte[] abyte2 = new byte[this.significantBytes];
        if (this.padded) {
            if (this.rsaPrivateKey != null) {
                abyte2[0] = 0;
                abyte2[1] = 1;
                for (int l = 2; l != abyte2.length; ++l) {
                    abyte2[l] = -1;
                }
            } else {
                this.random.nextBytes(abyte2);
                abyte2[0] = 0;
                abyte2[1] = 2;
                for (int i1 = 2; i1 != abyte2.length; ++i1) {
                    if (abyte2[i1] != 0) continue;
                    abyte2[i1] = (byte)(0xFF & ~i1);
                }
            }
            abyte2[abyte2.length - j - 1] = 0;
        }
        System.arraycopy(abyte0, i, abyte2, abyte2.length - j, j);
        abyte2 = this.encrypt(abyte2);
        if (abyte2.length >= this.significantBytes) {
            System.arraycopy(abyte2, abyte2.length - this.significantBytes, abyte1, k, this.significantBytes);
        } else {
            int j1 = this.significantBytes - abyte2.length;
            for (int k1 = 0; k1 <= j1; ++k1) {
                abyte1[k + k1] = 0;
            }
            System.arraycopy(abyte2, 0, abyte1, k + j1, abyte2.length);
        }
        return this.significantBytes;
    }

    protected int engineGetBlockSize() {
        if (this.mode == 2) {
            return this.significantBytes;
        }
        return this.significantBytes - 11;
    }

    protected int engineGetOutputSize(int i) {
        int j = this.engineGetBlockSize();
        i += this.bufferPos;
        if (this.mode == 2) {
            return i / j * (j - 11);
        }
        return (i + j - 1) / j * this.significantBytes;
    }

    public void engineSetMode(String s) throws NoSuchAlgorithmException {
        if (!s.equals("ECB")) {
            throw new NoSuchAlgorithmException("RSA only supports ECB.");
        }
    }

    public void engineSetPadding(String s) throws NoSuchPaddingException {
        if (s.equals("PKCS1Padding")) {
            this.padded = true;
        } else if (s.equals("NoPadding")) {
            this.padded = false;
        } else {
            throw new NoSuchPaddingException("RSA only supports PKCS1.");
        }
    }

    protected void setKey(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("expecting RSAPrivateKey/RSAPrivateCrtKey/RSAPublicKey");
        }
        int i = 0;
        if (key instanceof RSAPublicKey) {
            this.rsaPublicKey = (RSAPublicKey)key;
            this.rsaPrivateKey = null;
            i = this.rsaPublicKey.getModulus().bitLength();
        } else {
            this.rsaPrivateKey = (RSAPrivateKey)key;
            this.rsaPublicKey = null;
            i = this.rsaPrivateKey.getModulus().bitLength();
        }
        this.significantBytes = (i + 8 - 1) / 8;
        this.buffer = new byte[this.engineGetBlockSize()];
    }
}

