/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigHelper {
    private List<String> keys;
    private List<String> values;

    public static ConfigHelper conf(List<String> keys, List<String> values) {
        ConfigHelper helper = new ConfigHelper();
        helper.keys = keys;
        helper.values = values;
        return helper;
    }

    public static ConfigHelper conf(Map<String, String> config) {
        Preconditions.checkNotNull(config);
        ConfigHelper helper = new ConfigHelper();
        helper.keys = Lists.newArrayList((Iterable)config.keySet().stream().sorted().collect(Collectors.toList()));
        helper.values = helper.keys.stream().map(config::get).collect(Collectors.toList());
        return helper;
    }

    public Map<String, String> asMap() {
        Preconditions.checkState((this.keys != null && this.values != null && this.keys.size() == this.values.size() ? 1 : 0) != 0);
        return Maps.toMap(this.keys, key -> this.values.get(this.keys.indexOf(key)));
    }

    public List<String> keys() {
        return this.keys;
    }

    public List<String> vals() {
        return this.values;
    }
}

