/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanInjector;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.step.StepMetaInterface;

@XmlRootElement(name="step-props")
public class StepMetaProps {
    static final String STEP_TAG = "step-props";
    @XmlAttribute(name="secure")
    private List<String> secureFields;
    private StepMetaInterface stepMeta;
    private VariableSpace variableSpace = new Variables();
    @XmlElement(name="group")
    private List<PropGroup> groups = new ArrayList<PropGroup>();

    private StepMetaProps() {
    }

    private StepMetaProps(StepMetaInterface smi) {
        this.secureFields = StepMetaProps.sensitiveFields(smi.getClass());
    }

    public static StepMetaProps from(StepMetaInterface stepMeta) {
        StepMetaProps propMap = new StepMetaProps(stepMeta);
        propMap.stepMeta = stepMeta;
        BeanInjectionInfo info = new BeanInjectionInfo(stepMeta.getClass());
        BeanInjector injector = new BeanInjector(info);
        propMap.populateGroups(stepMeta, info, injector);
        return propMap;
    }

    public StepMetaInterface to(StepMetaInterface stepMetaInterface) {
        BeanInjectionInfo info = new BeanInjectionInfo(stepMetaInterface.getClass());
        BeanInjector injector = new BeanInjector(info);
        info.getProperties().values().forEach(property -> this.assignValueForProp((BeanInjectionInfo.Property)property, stepMetaInterface, injector));
        return stepMetaInterface;
    }

    public StepMetaProps withVariables(VariableSpace space) {
        StepMetaProps propCopy = StepMetaProps.from(this.stepMeta);
        propCopy.variableSpace = space;
        return propCopy;
    }

    private void populateGroups(StepMetaInterface stepMeta, BeanInjectionInfo info, BeanInjector injector) {
        this.groups = info.getGroups().stream().flatMap(group -> group.getGroupProperties().stream()).map(this.getProp(stepMeta, injector)).collect(Collectors.groupingBy(Prop::getGroup)).entrySet().stream().map(entry -> new PropGroup((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<String> sensitiveFields(Class clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        return Stream.concat(Arrays.stream(declaredFields), StepMetaProps.recurseDeep(declaredFields)).filter(field -> field.getAnnotation(Sensitive.class) != null).filter(field -> field.getAnnotation(Injection.class) != null).map(field -> field.getAnnotation(Injection.class).name()).collect(Collectors.toList());
    }

    private static Stream<Field> recurseDeep(Field[] topLevelFields) {
        Stream<Field> deepInjectionFields = Stream.empty();
        if (Arrays.stream(topLevelFields).anyMatch(StepMetaProps.isInjectionDeep())) {
            deepInjectionFields = Arrays.stream(topLevelFields).filter(StepMetaProps.isInjectionDeep()).flatMap(field -> Arrays.stream(field.getType().getDeclaredFields()));
            List<Field> deepFields = deepInjectionFields.collect(Collectors.toList());
            return Stream.concat(deepFields.stream(), StepMetaProps.recurseDeep(deepFields.toArray(new Field[0])));
        }
        return deepInjectionFields;
    }

    private static Predicate<Field> isInjectionDeep() {
        return field -> field.getAnnotation(InjectionDeep.class) != null;
    }

    private Function<BeanInjectionInfo.Property, Prop> getProp(StepMetaInterface stepMeta, BeanInjector injector) {
        return prop -> new Prop(prop.getName(), this.getPropVal(stepMeta, injector, (BeanInjectionInfo.Property)prop), prop.getGroupName());
    }

    private List<Object> getPropVal(StepMetaInterface stepMeta, BeanInjector injector, BeanInjectionInfo.Property prop) {
        try {
            Object o = injector.getPropVal(stepMeta, prop.getName());
            List<Object> ret = o instanceof List ? (List<Object>)o : (o instanceof Object[] ? Arrays.asList((Object[])o) : Collections.singletonList(o));
            return this.maybeEncrypt(prop.getName(), ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> maybeEncrypt(String name, List<Object> ret) {
        if (this.secureFields.contains(name)) {
            return ret.stream().map(val -> val == null || val.toString().isEmpty() ? "" : Encr.encryptPasswordIfNotUsingVariables((String)val.toString())).collect(Collectors.toList());
        }
        return ret;
    }

    private void assignValueForProp(BeanInjectionInfo.Property beanInfoProp, StepMetaInterface stepMetaInterface, BeanInjector injector) {
        List<Prop> props = this.groups.stream().filter(group -> beanInfoProp.getGroupName().equals(group.name)).flatMap(group -> group.props.stream()).filter(prop -> beanInfoProp.getName().equals(prop.name)).collect(Collectors.toList());
        this.decryptVals(props);
        props.forEach(entry -> this.injectVal(beanInfoProp, (Prop)entry, stepMetaInterface, injector));
    }

    private void decryptVals(List<Prop> props) {
        props.stream().filter(prop -> this.secureFields.contains(prop.getName())).forEach(prop -> {
            prop.value = prop.value.stream().map(Object::toString).map(Encr::decryptPasswordOptionallyEncrypted).collect(Collectors.toList());
        });
    }

    private void injectVal(BeanInjectionInfo.Property beanInfoProp, Prop prop, StepMetaInterface stepMetaInterface, BeanInjector injector) {
        if (prop.value == null || prop.value.size() == 0) {
            prop.value = Collections.singletonList(null);
        }
        try {
            injector.setProperty(stepMetaInterface, beanInfoProp.getName(), prop.value.stream().map(value -> {
                RowMetaAndData rmad = new RowMetaAndData();
                rmad.addValue((ValueMetaInterface)new ValueMetaString(prop.getName()), this.envSubs(value));
                return rmad;
            }).collect(Collectors.toList()), beanInfoProp.getName());
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private Object envSubs(Object value) {
        if (value instanceof String) {
            return this.variableSpace.environmentSubstitute(value.toString());
        }
        return value;
    }

    public String toString() {
        return "StepMetaProps{groups=" + this.groups + '}';
    }

    private static class Prop {
        @XmlAttribute
        String group;
        @XmlAttribute
        String name;
        @XmlElement(name="value")
        List<Object> value = new ArrayList<Object>();

        public Prop() {
        }

        private Prop(String name, List<Object> value, String group) {
            this.group = group;
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getGroup() {
            return this.group;
        }

        public String toString() {
            return "\n  Prop{group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class PropGroup {
        @XmlAttribute
        String name;
        @XmlElement(name="property")
        List<Prop> props;

        public PropGroup() {
        }

        PropGroup(String name, List<Prop> propList) {
            this.name = name;
            this.props = propList;
        }

        public String toString() {
            return "PropGroup{name='" + this.name + '\'' + ", props=" + this.props + '}';
        }
    }
}

