/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.Index;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

class GtIndex
extends Index {
    private final boolean isMatchingLessOrEqual;

    static Index lessOrEqualCache(int column, ValueMetaInterface valueMeta, int rowsAmount) {
        return new GtIndex(column, valueMeta, rowsAmount, true);
    }

    GtIndex(int column, ValueMetaInterface valueMeta, int rowsAmount) {
        this(column, valueMeta, rowsAmount, false);
    }

    GtIndex(int column, ValueMetaInterface valueMeta, int rowsAmount, boolean isMatchingLessOrEqual) {
        super(column, valueMeta, rowsAmount);
        this.isMatchingLessOrEqual = isMatchingLessOrEqual;
    }

    @Override
    void doApply(SearchingContext context, ValueMetaInterface lookupMeta, Object lookupValue) {
        int length;
        int firstValue = this.findInsertionPointOf(new Index.IndexedValue(lookupValue, Integer.MAX_VALUE));
        if (firstValue == (length = this.values.length)) {
            if (this.isMatchingLessOrEqual) {
                return;
            }
            context.setEmpty();
        } else {
            int end;
            int start;
            BitSet bitSet = context.getWorkingSet();
            if (firstValue < length / 2) {
                start = 0;
                end = firstValue;
            } else {
                start = firstValue;
                end = length;
            }
            for (int i = start; i < end; ++i) {
                bitSet.set(this.values[i].row, true);
            }
            context.intersect(bitSet, start == 0 ^ this.isMatchingLessOrEqual);
        }
    }

    @Override
    int getRestrictionPower() {
        return -1000;
    }
}

