/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;

public class LdapProtocol {
    private static Class<?> PKG = LdapProtocol.class;
    private final String hostname;
    private final int port;
    private final String derefAliases;
    private final String referral;
    private final LogChannelInterface log;
    private InitialLdapContext ctx;
    private final Set<String> binaryAttributes;

    public InitialLdapContext getCtx() {
        return this.ctx;
    }

    public LdapProtocol(LogChannelInterface log, VariableSpace variableSpace, LdapMeta meta, Collection<String> binaryAttributes) {
        this.log = log;
        this.hostname = variableSpace.environmentSubstitute(meta.getHost());
        this.port = Const.toInt((String)variableSpace.environmentSubstitute(meta.getPort()), (int)389);
        this.derefAliases = meta.getDerefAliases();
        this.referral = meta.getReferrals();
        this.binaryAttributes = binaryAttributes == null ? new HashSet<String>() : new HashSet<String>(binaryAttributes);
    }

    protected String getConnectionPrefix() {
        return "ldap://";
    }

    public static String getName() {
        return "LDAP";
    }

    protected void setupEnvironment(Map<String, String> env, String username, String password) throws KettleException {
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.derefAliases", this.derefAliases);
        env.put("java.naming.referral", this.referral);
        if (this.hostname.startsWith(this.getConnectionPrefix())) {
            env.put("java.naming.provider.url", this.hostname + ":" + this.port);
        } else {
            env.put("java.naming.provider.url", this.getConnectionPrefix() + this.hostname + ":" + this.port);
        }
        if (!Utils.isEmpty((CharSequence)username)) {
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.security.authentication", "simple");
        } else {
            env.put("java.naming.security.authentication", "none");
        }
        if (this.binaryAttributes.size() > 0) {
            env.put("java.naming.ldap.attributes.binary", Joiner.on((String)" ").join(this.binaryAttributes));
        }
    }

    protected InitialLdapContext createLdapContext(Hashtable<String, String> env) throws NamingException {
        return new InitialLdapContext(env, null);
    }

    protected void doConnect(String username, String password) throws KettleException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.setupEnvironment(env, username, password);
        try {
            this.ctx = this.createLdapContext(env);
        }
        catch (NamingException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public final void connect(String username, String password) throws KettleException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.setupEnvironment(env, username, password);
        try {
            this.doConnect(username, password);
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"LDAPInput.Log.ConnectedToServer", (String[])new String[]{this.hostname, Const.NVL((String)username, (String)"")}));
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"LDAPInput.ClassUsed.Message", (String[])new String[]{this.ctx.getClass().getName()}));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPinput.Exception.ErrorConnecting", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void close() throws KettleException {
        if (this.ctx != null) {
            try {
                this.ctx.close();
                if (this.log.isBasic()) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"LDAPInput.log.Disconnection.Done", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"LDAPInput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
                this.log.logError(Const.getStackTracker((Throwable)e));
            }
            finally {
                this.ctx = null;
            }
        }
    }
}

