/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapoutput;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPConnection;
import org.pentaho.di.trans.steps.ldapoutput.LDAPOutputData;
import org.pentaho.di.trans.steps.ldapoutput.LDAPOutputMeta;

public class LDAPOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LDAPOutputMeta.class;
    private LDAPOutputMeta meta;
    private LDAPOutputData data;

    public LDAPOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            if (this.meta.getOperationType() != 4 && this.meta.getOperationType() != 5) {
                int i;
                this.data.nrfields = this.meta.getUpdateLookup().length;
                if (this.data.nrfields == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutputUpdateDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
                }
                this.data.fieldsAttribute = new String[this.data.nrfields];
                this.data.fieldStream = new int[this.data.nrfields];
                ArrayList<Integer> fieldsToUpdateInStreaml = new ArrayList<Integer>();
                ArrayList<String> fieldsToUpdateAttributel = new ArrayList<String>();
                for (i = 0; i < this.data.nrfields; ++i) {
                    this.data.fieldStream[i] = this.getInputRowMeta().indexOfValue(this.environmentSubstitute(this.meta.getUpdateStream()[i]));
                    if (this.data.fieldStream[i] < 0) {
                        throw new KettleException("Field [" + this.meta.getUpdateStream()[i] + "] couldn't be found in the input stream!");
                    }
                    this.data.fieldsAttribute[i] = this.environmentSubstitute(this.meta.getUpdateLookup()[i]);
                    if (this.meta.getOperationType() != 1 || !this.meta.getUpdate()[i].booleanValue()) continue;
                    fieldsToUpdateInStreaml.add(this.data.fieldStream[i]);
                    fieldsToUpdateAttributel.add(this.data.fieldsAttribute[i]);
                }
                this.data.nrfieldsToUpdate = fieldsToUpdateInStreaml.size();
                if (this.data.nrfieldsToUpdate > 0) {
                    this.data.fieldStreamToUpdate = new int[this.data.nrfieldsToUpdate];
                    this.data.fieldsAttributeToUpdate = new String[this.data.nrfieldsToUpdate];
                    for (i = 0; i < fieldsToUpdateInStreaml.size(); ++i) {
                        this.data.fieldStreamToUpdate[i] = (Integer)fieldsToUpdateInStreaml.get(i);
                        this.data.fieldsAttributeToUpdate[i] = (String)fieldsToUpdateAttributel.get(i);
                    }
                }
                fieldsToUpdateInStreaml = null;
                fieldsToUpdateAttributel = null;
                this.data.attributes = new String[this.data.nrfields];
                if (this.meta.getOperationType() == 1 && this.data.nrfieldsToUpdate > 0) {
                    this.data.attributesToUpdate = new String[this.data.nrfieldsToUpdate];
                }
            }
            if (this.meta.getOperationType() == 5) {
                String oldDnField = this.environmentSubstitute(this.meta.getOldDnFieldName());
                if (Utils.isEmpty((CharSequence)oldDnField)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.OldDNFieldMissing", (String[])new String[0]));
                }
                String newDnField = this.environmentSubstitute(this.meta.getNewDnFieldName());
                if (Utils.isEmpty((CharSequence)newDnField)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.NewDNFieldMissing", (String[])new String[0]));
                }
                this.data.indexOfOldDNField = this.getInputRowMeta().indexOfValue(oldDnField);
                if (this.data.indexOfOldDNField < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.CanNotFindField", (String[])new String[]{oldDnField}));
                }
                this.data.indexOfNewDNField = this.getInputRowMeta().indexOfValue(newDnField);
                if (this.data.indexOfNewDNField < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.CanNotFindField", (String[])new String[]{newDnField}));
                }
            } else {
                String dnField = this.environmentSubstitute(this.meta.getDnField());
                if (Utils.isEmpty((CharSequence)dnField)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.DNFieldMissing", (String[])new String[0]));
                }
                this.data.indexOfDNField = this.getInputRowMeta().indexOfValue(dnField);
                if (this.data.indexOfDNField < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.CanNotFindField", (String[])new String[]{dnField}));
                }
            }
        }
        this.incrementLinesInput();
        String dn = null;
        try {
            if (this.meta.getOperationType() != 5) {
                dn = this.getInputRowMeta().getString(outputRowData, this.data.indexOfDNField);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"LDAPOutput.ProcessDn", (String[])new String[]{dn}));
                }
                if (this.meta.getOperationType() != 4) {
                    for (int i = 0; i < this.data.nrfields; ++i) {
                        this.data.attributes[i] = this.getInputRowMeta().getString(outputRowData, this.data.fieldStream[i]);
                    }
                }
            }
            block1 : switch (this.meta.getOperationType()) {
                case 1: {
                    for (int i = 0; i < this.data.nrfieldsToUpdate; ++i) {
                        this.data.attributesToUpdate[i] = this.getInputRowMeta().getString(outputRowData, this.data.fieldStreamToUpdate[i]);
                    }
                    int status = this.data.connection.upsert(dn, this.data.fieldsAttribute, this.data.attributes, this.data.fieldsAttributeToUpdate, this.data.attributesToUpdate, this.data.separator);
                    switch (status) {
                        case 1: {
                            this.incrementLinesOutput();
                            break block1;
                        }
                        case 2: {
                            this.incrementLinesUpdated();
                            break block1;
                        }
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 2: {
                    int status = this.data.connection.update(dn, this.data.fieldsAttribute, this.data.attributes, this.meta.isFailIfNotExist());
                    switch (status) {
                        case 2: {
                            this.incrementLinesUpdated();
                            break block1;
                        }
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 3: {
                    int status = this.data.connection.add(dn, this.data.fieldsAttribute, this.data.attributes, this.data.separator, this.meta.isFailIfNotExist());
                    switch (status) {
                        case 4: {
                            this.incrementLinesUpdated();
                            break block1;
                        }
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 4: {
                    int status = this.data.connection.delete(dn, this.meta.isFailIfNotExist());
                    switch (status) {
                        case 3: {
                            this.incrementLinesUpdated();
                            break block1;
                        }
                    }
                    this.incrementLinesSkipped();
                    break;
                }
                case 5: {
                    String oldDn = this.getInputRowMeta().getString(outputRowData, this.data.indexOfOldDNField);
                    String newDn = this.getInputRowMeta().getString(outputRowData, this.data.indexOfNewDNField);
                    this.data.connection.rename(oldDn, newDn, this.meta.isDeleteRDN());
                    this.incrementLinesOutput();
                    break;
                }
                default: {
                    this.data.connection.insert(dn, this.data.fieldsAttribute, this.data.attributes, this.data.separator);
                    this.incrementLinesOutput();
                }
            }
            this.putRow(this.getInputRowMeta(), outputRowData);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"LDAPOutput.log.ReadRow", (String[])new String[0]), this.getInputRowMeta().getString(outputRowData));
            }
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDAPOutput.log.LineRow", (String[])new String[0]) + this.getLinesInput());
            }
            return true;
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPOutput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.logError(Const.getStackTracker((Throwable)e));
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "LDAPOutput001");
            }
            return true;
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPOutputMeta)smi;
        this.data = (LDAPOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.connection = new LDAPConnection(this.log, this, this.meta, null);
                if (this.meta.UseAuthentication()) {
                    String username = this.environmentSubstitute(this.meta.getUserName());
                    String password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getPassword()));
                    this.data.connection.connect(username, password);
                } else {
                    this.data.connection.connect();
                }
                this.data.separator = this.environmentSubstitute(this.meta.getMultiValuedSeparator());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPOutput.Error.Init", (Object[])new Object[]{e}));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPOutputMeta)smi;
        this.data = (LDAPOutputData)sdi;
        if (this.data.connection != null) {
            try {
                this.data.connection.close();
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"LDAPOutput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
            }
        }
        super.dispose(smi, sdi);
    }
}

