/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.simplemapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;
import org.pentaho.di.trans.steps.simplemapping.SimpleMapping;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SimpleMappingMeta
extends StepWithMappingMeta
implements StepMetaInterface,
HasRepositoryInterface,
ISubTransAwareMeta {
    private static Class<?> PKG = SimpleMappingMeta.class;
    private MappingIODefinition inputMapping = new MappingIODefinition();
    private MappingIODefinition outputMapping = new MappingIODefinition();
    private MappingParameters mappingParameters = new MappingParameters();
    private Repository repository;
    private IMetaStore metaStore;

    private void checkObjectLocationSpecificationMethod() {
        if (this.specificationMethod == null) {
            this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            if (!Utils.isEmpty((CharSequence)this.fileName)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            } else if (this.transObjectId != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
            } else if (!Utils.isEmpty((CharSequence)this.transName)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)stepnode, (String)"trans_object_id");
            this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
            this.transName = XMLHandler.getTagValue((Node)stepnode, (String)"trans_name");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
            this.checkObjectLocationSpecificationMethod();
            Node mappingsNode = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
            if (mappingsNode == null) {
                throw new KettleXMLException("Unable to find <mappings> element in the step XML");
            }
            Node inputNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"input");
            Node mappingNode = XMLHandler.getSubNode((Node)inputNode, (String)"mapping");
            this.inputMapping = mappingNode != null ? new MappingIODefinition(mappingNode) : new MappingIODefinition();
            Node outputNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"output");
            mappingNode = XMLHandler.getSubNode((Node)outputNode, (String)"mapping");
            this.outputMapping = mappingNode != null ? new MappingIODefinition(mappingNode) : new MappingIODefinition();
            Node mappingParametersNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"parameters");
            this.mappingParameters = new MappingParameters(mappingParametersNode);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SimpleMappingMeta.Exception.ErrorLoadingTransformationStepFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString()));
        if (this.repository != null && this.transObjectId != null) {
            try {
                RepositoryObject objectInformation = this.repository.getObjectInformation(this.transObjectId, RepositoryObjectType.TRANSFORMATION);
                if (objectInformation != null) {
                    this.transName = objectInformation.getName();
                    this.directoryPath = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_name", (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.openTag((String)"mappings")).append(Const.CR);
        retval.append("      ").append(XMLHandler.openTag((String)"input")).append(Const.CR);
        retval.append(this.inputMapping.getXML());
        retval.append("      ").append(XMLHandler.closeTag((String)"input")).append(Const.CR);
        retval.append("      ").append(XMLHandler.openTag((String)"output")).append(Const.CR);
        retval.append(this.outputMapping.getXML());
        retval.append("      ").append(XMLHandler.closeTag((String)"output")).append(Const.CR);
        retval.append("      ").append(this.mappingParameters.getXML()).append(Const.CR);
        retval.append("    ").append(XMLHandler.closeTag((String)"mappings")).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        String method = rep.getStepAttributeString(id_step, "specification_method");
        this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
        String transId = rep.getStepAttributeString(id_step, "trans_object_id");
        this.transObjectId = Utils.isEmpty((CharSequence)transId) ? null : new StringObjectId(transId);
        this.transName = rep.getStepAttributeString(id_step, "trans_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        this.checkObjectLocationSpecificationMethod();
        this.inputMapping = new MappingIODefinition(rep, id_step, "input_", 0);
        this.outputMapping = new MappingIODefinition(rep, id_step, "output_", 0);
        this.mappingParameters = new MappingParameters(rep, id_step);
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
        rep.saveStepAttribute(id_transformation, id_step, "trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString());
        rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
        rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.transName);
        rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
        this.inputMapping.saveRep(rep, metaStore, id_transformation, id_step, "input_", 0);
        this.outputMapping.saveRep(rep, metaStore, id_transformation, id_step, "output_", 0);
        this.mappingParameters.saveRep(rep, metaStore, id_transformation, id_step);
    }

    @Override
    public void setDefault() {
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        MappingIODefinition inputDefinition = new MappingIODefinition(null, null);
        inputDefinition.setMainDataPath(true);
        inputDefinition.setRenamingOnOutput(true);
        this.inputMapping = inputDefinition;
        MappingIODefinition outputDefinition = new MappingIODefinition(null, null);
        outputDefinition.setMainDataPath(true);
        this.outputMapping = outputDefinition;
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        TransMeta mappingTransMeta = null;
        try {
            mappingTransMeta = SimpleMappingMeta.loadMappingMeta(this, repository, metaStore, space, this.mappingParameters.isInheritingAllVariables());
        }
        catch (KettleException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SimpleMappingMeta.Exception.UnableToLoadMappingTransformation", (String[])new String[0]), (Throwable)e);
        }
        if (this.mappingParameters != null && mappingTransMeta != null) {
            StepWithMappingMeta.activateParams(mappingTransMeta, mappingTransMeta, space, mappingTransMeta.listParameters(), this.mappingParameters.getVariable(), this.mappingParameters.getInputField());
        }
        ArrayList<MappingValueRename> inputRenameList = new ArrayList<MappingValueRename>();
        RowMetaInterface inputRowMeta = row.clone();
        if (!inputRowMeta.isEmpty()) {
            for (MappingValueRename valueRename : this.inputMapping.getValueRenames()) {
                ValueMetaInterface valueMeta = inputRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SimpleMappingMeta.Exception.UnableToFindField", (String[])new String[]{valueRename.getSourceValueName()}));
                }
                valueMeta.setName(valueRename.getTargetValueName());
            }
        }
        StepMeta mappingInputStep = mappingTransMeta.findMappingInputStep(null);
        MappingInputMeta mappingInputMeta = (MappingInputMeta)mappingInputStep.getStepMetaInterface();
        mappingInputMeta.setInputRowMeta(inputRowMeta);
        mappingInputMeta.setValueRenames(null);
        if (this.inputMapping.isRenamingOnOutput()) {
            SimpleMapping.addInputRenames(inputRenameList, this.inputMapping.getValueRenames());
        }
        StepMeta mappingOutputStep = mappingTransMeta.findMappingOutputStep(null);
        MappingOutputMeta mappingOutputMeta = (MappingOutputMeta)mappingOutputStep.getStepMetaInterface();
        mappingOutputMeta.setOutputValueRenames(this.outputMapping.getValueRenames());
        mappingOutputMeta.setInputValueRenames(inputRenameList);
        RowMetaInterface mappingOutputRowMeta = mappingTransMeta.getStepFields(mappingOutputStep);
        row.clear();
        row.addRowMeta(mappingOutputRowMeta);
    }

    public String[] getInfoSteps() {
        return null;
    }

    public String[] getTargetSteps() {
        return null;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.StepReceivingFieldsFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new SimpleMapping(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SimpleMappingData();
    }

    public MappingParameters getMappingParameters() {
        return this.mappingParameters;
    }

    public void setMappingParameters(MappingParameters mappingParameters) {
        this.mappingParameters = mappingParameters;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.transName);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Utils.isEmpty((CharSequence)realTransname)) {
            reference.getEntries().add(new ResourceEntry(realTransname, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        StepIOMetaInterface ioMeta = super.getStepIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.setStepIOMeta(ioMeta);
        }
        return ioMeta;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return false;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directoryPath);
        this.transObjectId = repository.getTransformationID(this.transName, repositoryDirectoryInterface);
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"SimpleMappingMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isMapppingDefined() {
        return !Utils.isEmpty((CharSequence)this.fileName) || this.transObjectId != null || !Utils.isEmpty((CharSequence)this.directoryPath) && !Utils.isEmpty((CharSequence)this.transName);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isMapppingDefined()};
    }

    @Override
    @Deprecated
    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        return this.loadReferencedObject(index, rep, null, space);
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return SimpleMappingMeta.loadMappingMeta(this, rep, metaStore, space);
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public MappingIODefinition getInputMapping() {
        return this.inputMapping;
    }

    public void setInputMapping(MappingIODefinition inputMapping) {
        this.inputMapping = inputMapping;
    }

    public MappingIODefinition getOutputMapping() {
        return this.outputMapping;
    }

    public void setOutputMapping(MappingIODefinition outputMapping) {
        this.outputMapping = outputMapping;
    }

    @Override
    public List<MappingIODefinition> getInputMappings() {
        ArrayList<MappingIODefinition> inputMappings = new ArrayList<MappingIODefinition>();
        inputMappings.add(this.inputMapping);
        return inputMappings;
    }

    @Override
    public List<MappingIODefinition> getOutputMappings() {
        ArrayList<MappingIODefinition> outputMappings = new ArrayList<MappingIODefinition>();
        outputMappings.add(this.outputMapping);
        return outputMappings;
    }
}

