/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.changed;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.changed.PDIObserver;

public class ChangedFlag
implements ChangedFlagInterface {
    private Set<PDIObserver> obs = Collections.newSetFromMap(new ConcurrentHashMap());
    private AtomicBoolean changed = new AtomicBoolean();

    public void addObserver(PDIObserver o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.validateAdd(o);
    }

    private synchronized void validateAdd(PDIObserver o) {
        if (!this.obs.contains(o)) {
            this.obs.add(o);
        }
    }

    public void deleteObserver(PDIObserver o) {
        this.obs.remove(o);
    }

    public void notifyObservers(Object arg) {
        if (!this.changed.get()) {
            return;
        }
        PDIObserver[] lobs = this.obs.toArray(new PDIObserver[this.obs.size()]);
        this.clearChanged();
        for (int i = lobs.length - 1; i >= 0; --i) {
            lobs[i].update(this, arg);
        }
    }

    @Override
    public void setChanged() {
        this.changed.set(true);
    }

    @Override
    public void setChanged(boolean b) {
        this.changed.set(b);
    }

    @Override
    public void clearChanged() {
        this.changed.set(false);
    }

    @Override
    public boolean hasChanged() {
        return this.changed.get();
    }
}

