/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.pentaho.di.base.AbstractBaseCommandExecutor;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.base.Params;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PanCommandExecutor
extends AbstractBaseCommandExecutor {
    public PanCommandExecutor(Class<?> pkgClazz) {
        this(pkgClazz, (LogChannelInterface)new LogChannel((Object)"Pan"));
    }

    public PanCommandExecutor(Class<?> pkgClazz, LogChannelInterface log) {
        this.setPkgClazz(pkgClazz);
        this.setLog(log);
    }

    public Result execute(Params params) throws Throwable {
        return this.execute(params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result execute(Params params, String[] arguments) throws Throwable {
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.StartingToRun", (String[])new String[0]));
        this.logDebug("Pan.Log.AllocatteNewTrans");
        Trans trans = null;
        Repository repository = null;
        try {
            if (this.getMetaStore() == null) {
                this.setMetaStore(this.createDefaultMetastore());
            }
            this.logDebug("Pan.Log.StartingToLookOptions");
            if (!(Utils.isEmpty((CharSequence)params.getRepoName()) && Utils.isEmpty((CharSequence)params.getLocalFile()) && Utils.isEmpty((CharSequence)params.getLocalJarFile()))) {
                this.logDebug("Pan.Log.ParsingCommandline");
                if (!Utils.isEmpty((CharSequence)params.getRepoName()) && !this.isEnabled(params.getBlockRepoConns())) {
                    RepositoryMeta repositoryMeta;
                    if (this.isEnabled(params.getTrustRepoUser())) {
                        System.setProperty("pentaho.repository.client.attemptTrust", "Y");
                    }
                    if ((repositoryMeta = this.loadRepositoryConnection(params.getRepoName(), "Pan.Log.LoadingAvailableRep", "Pan.Error.NoRepsDefined", "Pan.Log.FindingRep")) == null) {
                        System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.CanNotConnectRep", (String[])new String[0]));
                        return this.exitWithStatus(CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode());
                    }
                    this.logDebug("Pan.Log.CheckSuppliedUserPass");
                    repository = this.establishRepositoryConnection(repositoryMeta, params.getRepoUsername(), params.getRepoPassword(), RepositoryOperation.EXECUTE_TRANSFORMATION);
                    if (this.isEnabled(params.getListRepoFiles()) || this.isEnabled(params.getListRepoDirs()) || !Utils.isEmpty((CharSequence)params.getExportRepo())) {
                        this.executeRepositoryBasedCommand(repository, params.getInputDir(), params.getListRepoFiles(), params.getListRepoDirs(), params.getExportRepo());
                        return this.exitWithStatus(CommandExecutorCodes.Pan.SUCCESS.getCode());
                    }
                    trans = this.loadTransFromRepository(repository, params.getInputDir(), params.getInputFile());
                }
                if (trans == null) {
                    trans = this.loadTransFromFilesystem(params.getLocalInitialDir(), params.getLocalFile(), params.getLocalJarFile(), (Serializable)((Object)params.getBase64Zip()));
                }
            }
            if (this.isEnabled(params.getListRepos())) {
                this.printRepositories(this.loadRepositoryInfo("Pan.Log.LoadingAvailableRep", "Pan.Error.NoRepsDefined"));
            }
        }
        catch (Exception e) {
            trans = null;
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.ProcessStopError", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
            if (repository != null) {
                repository.disconnect();
            }
            return this.exitWithStatus(CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode());
        }
        if (trans == null) {
            if (!this.isEnabled(params.getListRepoFiles()) && !this.isEnabled(params.getListRepoDirs()) && !this.isEnabled(params.getListRepos()) && Utils.isEmpty((CharSequence)params.getExportRepo())) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.CanNotLoadTrans", (String[])new String[0]));
                return this.exitWithStatus(CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode());
            }
            return this.exitWithStatus(CommandExecutorCodes.Pan.SUCCESS.getCode());
        }
        Date start = Calendar.getInstance().getTime();
        try {
            trans.setLogLevel(this.getLog().getLogLevel());
            PanCommandExecutor.configureParameters(trans, params.getNamedParams(), trans.getTransMeta());
            trans.setSafeModeEnabled(this.isEnabled(params.getSafeMode()));
            trans.setGatheringMetrics(this.isEnabled(params.getMetrics()));
            if (this.isEnabled(params.getListFileParams())) {
                this.printTransformationParameters(trans);
                Result result = this.exitWithStatus(CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode());
                return result;
            }
            final ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
            try {
                trans.prepareExecution(arguments);
                if (!StringUtils.isEmpty((String)params.getResultSetStepName())) {
                    int copyNr = NumberUtils.isNumber((String)params.getResultSetCopyNumber()) ? Integer.parseInt(params.getResultSetCopyNumber()) : 0;
                    this.logDebug("Collecting result-set for step '" + params.getResultSetStepName() + "' and copy number " + copyNr);
                    StepInterface step = null;
                    step = trans.findRunThread(params.getResultSetStepName());
                    if (step != null && step.getCopy() == copyNr) {
                        step.addRowListener(new RowAdapter(){

                            @Override
                            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] data) throws KettleStepException {
                                rows.add(new RowMetaAndData(rowMeta, data));
                            }
                        });
                    }
                }
                trans.startThreads();
            }
            catch (KettleException ke) {
                this.logDebug(ke.getLocalizedMessage());
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.UnablePrepareInitTrans", (String[])new String[0]));
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.getLog(), (String)KettleExtensionPoint.TransformationFinish.id, (Object)trans);
                Result step = this.exitWithStatus(CommandExecutorCodes.Pan.UNABLE_TO_PREP_INIT_TRANS.getCode());
                if (repository != null) {
                    repository.disconnect();
                }
                if (this.isEnabled(params.getTrustRepoUser())) {
                    System.clearProperty("pentaho.repository.client.attemptTrust");
                }
                return step;
            }
            this.waitUntilFinished(trans, 100L);
            if (trans.isRunning()) {
                this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.NotStopping", (String[])new String[0]));
            }
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.Finished", (String[])new String[0]));
            Date stop = Calendar.getInstance().getTime();
            trans.setResultRows(rows);
            this.setResult(trans.getResult());
            int completionTimeSeconds = this.calculateAndPrintElapsedTime(start, stop, "Pan.Log.StartStop", "Pan.Log.ProcessingEndAfter", "Pan.Log.ProcessingEndAfterLong", "Pan.Log.ProcessingEndAfterLonger", "Pan.Log.ProcessingEndAfterLongest");
            this.getResult().setElapsedTimeMillis(stop.getTime() - start.getTime());
            if (this.getResult().getNrErrors() == 0L) {
                trans.printStats(completionTimeSeconds);
                Result result = this.exitWithStatus(CommandExecutorCodes.Pan.SUCCESS.getCode());
                return result;
            }
            String transJVMExitCode = trans.getVariable("KETTLE_TRANS_PAN_JVM_EXIT_CODE");
            if (!Utils.isEmpty((CharSequence)transJVMExitCode)) {
                try {
                    Result result = this.exitWithStatus(Integer.parseInt(transJVMExitCode));
                    return result;
                }
                catch (NumberFormatException nfe) {
                    Result result;
                    block38: {
                        this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.TransJVMExitCodeInvalid", (String[])new String[]{"KETTLE_TRANS_PAN_JVM_EXIT_CODE", transJVMExitCode}));
                        this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.JVMExitCode", (String[])new String[]{"1"}));
                        result = this.exitWithStatus(CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode());
                        if (repository == null) break block38;
                        repository.disconnect();
                    }
                    if (this.isEnabled(params.getTrustRepoUser())) {
                        System.clearProperty("pentaho.repository.client.attemptTrust");
                    }
                    return result;
                }
            }
            Result result = this.exitWithStatus(CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode());
            return result;
            {
                catch (KettleException ke) {
                    System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.ErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
                    this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.UnexpectedErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
                    Result result2 = this.exitWithStatus(CommandExecutorCodes.Pan.UNEXPECTED_ERROR.getCode());
                    return result2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
            if (this.isEnabled(params.getTrustRepoUser())) {
                System.clearProperty("pentaho.repository.client.attemptTrust");
            }
        }
    }

    public int printVersion() {
        this.printVersion("Pan.Log.KettleVersion");
        return CommandExecutorCodes.Pan.KETTLE_VERSION_PRINT.getCode();
    }

    protected void executeRepositoryBasedCommand(Repository repository, String dirName, String listTrans, String listDirs, String exportRepo) throws Exception {
        RepositoryDirectoryInterface directory = this.loadRepositoryDirectory(repository, dirName, "Pan.Error.NoRepProvided", "Pan.Log.Allocate&ConnectRep", "Pan.Error.CanNotFindSpecifiedDirectory");
        if (directory == null) {
            return;
        }
        if (this.isEnabled(listTrans)) {
            this.printRepositoryStoredTransformations(repository, directory);
        } else if (this.isEnabled(listDirs)) {
            this.printRepositoryDirectories(repository, directory);
        } else if (!Utils.isEmpty((CharSequence)exportRepo)) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.ExportingObjectsRepToFile", (String[])new String[]{"" + exportRepo}));
            repository.getExporter().exportAllObjects(null, exportRepo, directory, "all");
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.FinishedExportObjectsRepToFile", (String[])new String[]{"" + exportRepo}));
        }
    }

    public Trans loadTransFromRepository(Repository repository, String dirName, String transName) throws Exception {
        if (Utils.isEmpty((CharSequence)transName)) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.NoTransNameSupplied", (String[])new String[0]));
            return null;
        }
        RepositoryDirectoryInterface directory = this.loadRepositoryDirectory(repository, dirName, "Pan.Error.NoRepProvided", "Pan.Log.Allocate&ConnectRep", "Pan.Error.CanNotFindSpecifiedDirectory");
        if (directory == null) {
            return null;
        }
        if (repository.getMetaStore() != null && this.getMetaStore() != null) {
            this.getMetaStore().addMetaStore(repository.getMetaStore());
        }
        this.logDebug("Pan.Log.LoadTransInfo");
        TransMeta transMeta = repository.loadTransformation(transName, directory, null, true, null);
        this.logDebug("Pan.Log.AllocateTrans");
        Trans trans = new Trans(transMeta);
        trans.setRepository(repository);
        trans.setMetaStore((IMetaStore)this.getMetaStore());
        return trans;
    }

    public Trans loadTransFromFilesystem(String initialDir, String filename, String jarFilename, Serializable base64Zip) throws Exception {
        File zip;
        Trans trans = null;
        if (base64Zip != null && (zip = this.decodeBase64ToZipFile(base64Zip, true)) != null) {
            filename = "zip:file:" + File.separator + File.separator + zip.getAbsolutePath() + "!" + filename;
        }
        if (!Utils.isEmpty((CharSequence)filename)) {
            String filepath = filename;
            if (!KettleVFS.startsWithScheme((String)filename) && !FileUtil.isFullyQualified(filename)) {
                filepath = initialDir + filename;
            }
            this.logDebug("Pan.Log.LoadingTransXML", "" + filepath);
            TransMeta transMeta = new TransMeta(filepath);
            trans = new Trans(transMeta);
        }
        if (!Utils.isEmpty((CharSequence)jarFilename)) {
            try {
                int c;
                this.logDebug("Pan.Log.LoadingTransJar", jarFilename);
                InputStream inputStream = PanCommandExecutor.class.getResourceAsStream(jarFilename);
                StringBuilder xml = new StringBuilder();
                while ((c = inputStream.read()) != -1) {
                    xml.append((char)c);
                }
                inputStream.close();
                Document document = XMLHandler.loadXMLString((String)xml.toString());
                TransMeta transMeta = new TransMeta(XMLHandler.getSubNode((Node)document, (String)"transformation"), null);
                trans = new Trans(transMeta);
            }
            catch (Exception e) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.ReadingJar", (String[])new String[]{e.toString()}));
                System.out.println(Const.getStackTracker((Throwable)e));
                throw e;
            }
        }
        if (trans != null) {
            trans.setMetaStore((IMetaStore)this.getMetaStore());
        }
        return trans;
    }

    protected static void configureParameters(Trans trans, NamedParams optionParams, TransMeta transMeta) throws UnknownParamException {
        String[] transParams;
        trans.initializeVariablesFrom(null);
        trans.getTransMeta().setInternalKettleVariables(trans);
        for (String param : transParams = trans.listParameters()) {
            String value = optionParams.getParameterValue(param);
            if (value == null) continue;
            trans.setParameterValue(param, value);
            transMeta.setParameterValue(param, value);
        }
        trans.activateParameters();
    }

    protected void printTransformationParameters(Trans trans) throws UnknownParamException {
        if (trans != null && trans.listParameters() != null) {
            for (String pName : trans.listParameters()) {
                this.printParameter(pName, trans.getParameterValue(pName), trans.getParameterDefault(pName), trans.getParameterDescription(pName));
            }
        }
    }

    protected void printRepositoryStoredTransformations(Repository repository, RepositoryDirectoryInterface directory) throws KettleException {
        this.logDebug("Pan.Log.GettingListTransDirectory", "" + directory);
        String[] transformations = repository.getTransformationNames(directory.getObjectId(), false);
        if (transformations != null) {
            for (String trans : transformations) {
                System.out.println(trans);
            }
        }
    }

    protected void printRepositories(RepositoriesMeta repositoriesMeta) {
        if (repositoriesMeta != null) {
            this.logDebug("Pan.Log.GettingListReps");
            for (int i = 0; i < repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta repInfo = repositoriesMeta.getRepository(i);
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.RepNameDesc", (String[])new String[]{"" + (i + 1), repInfo.getName(), repInfo.getDescription()}));
            }
        }
    }

    private void waitUntilFinished(Trans trans, long waitMillis) {
        if (trans != null && trans.isRunning()) {
            trans.waitUntilFinished();
            for (int i = 0; i < 100 && trans.isRunning(); ++i) {
                try {
                    Thread.sleep(waitMillis);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }
}

