/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;

public class DefaultCache
implements DatabaseLookupData.Cache {
    private final DatabaseLookupData data;
    private final LinkedHashMap<RowMetaAndData, Object[]> map;

    public static DefaultCache newCache(DatabaseLookupData data, int cacheSize) {
        cacheSize = cacheSize > 0 ? (int)((double)cacheSize * 1.5) : 16;
        return new DefaultCache(data, cacheSize);
    }

    DefaultCache(DatabaseLookupData data, int capacity) {
        this.data = data;
        this.map = new LinkedHashMap(capacity);
    }

    @Override
    public Object[] getRowFromCache(RowMetaInterface lookupMeta, Object[] lookupRow) throws KettleException {
        if (this.data.allEquals) {
            Object[] row = this.map.get(new RowMetaAndData(this.data.lookupMeta, lookupRow));
            if (row != null) {
                return row;
            }
        } else if (!this.data.hasDBCondition) {
            for (Map.Entry<RowMetaAndData, Object[]> entry : this.map.entrySet()) {
                Object[] row;
                RowMetaAndData key = entry.getKey();
                boolean match = true;
                int lookupIndex = 0;
                for (int i = 0; i < this.data.conditions.length && match; ++i) {
                    ValueMetaInterface cmpMeta = lookupMeta.getValueMeta(lookupIndex);
                    Object cmpData = lookupRow[lookupIndex];
                    ValueMetaInterface keyMeta = key.getValueMeta(i);
                    Object keyData = key.getData()[i];
                    switch (this.data.conditions[i]) {
                        case 0: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) == 0;
                            break;
                        }
                        case 1: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) != 0;
                            break;
                        }
                        case 2: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) > 0;
                            break;
                        }
                        case 3: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) >= 0;
                            break;
                        }
                        case 4: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) < 0;
                            break;
                        }
                        case 5: {
                            match = cmpMeta.compare(cmpData, keyMeta, keyData) <= 0;
                            break;
                        }
                        case 8: {
                            match = keyMeta.isNull(keyData);
                            break;
                        }
                        case 9: {
                            match = !keyMeta.isNull(keyData);
                            break;
                        }
                        case 7: {
                            ValueMetaInterface cmpMeta2 = lookupMeta.getValueMeta(lookupIndex + 1);
                            Object cmpData2 = lookupRow[lookupIndex + 1];
                            boolean bl = match = keyMeta.compare(keyData, cmpMeta, cmpData) >= 0;
                            if (match) {
                                match = keyMeta.compare(keyData, cmpMeta2, cmpData2) <= 0;
                            }
                            ++lookupIndex;
                            break;
                        }
                        default: {
                            match = false;
                            this.data.hasDBCondition = true;
                        }
                    }
                    ++lookupIndex;
                }
                if (!match || (row = entry.getValue()) == null) continue;
                return row;
            }
        }
        return null;
    }

    @Override
    public void storeRowInCache(DatabaseLookupMeta meta, RowMetaInterface lookupMeta, Object[] lookupRow, Object[] add) {
        RowMetaAndData rowMetaAndData = new RowMetaAndData(lookupMeta, lookupRow);
        if (!this.map.containsKey(rowMetaAndData)) {
            this.map.put(rowMetaAndData, add);
        }
        if (!meta.isLoadingAllDataInCache() && meta.getCacheSize() > 0 && this.map.size() > meta.getCacheSize()) {
            this.map.remove(this.map.entrySet().iterator().next().getKey());
        }
    }
}

