/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.poi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.excelinput.poi.PoiSheet;

public class PoiWorkbook
implements KWorkbook {
    private LogChannelInterface log;
    private Workbook workbook;
    private String filename;
    private String encoding;
    private InputStream internalIS;
    private NPOIFSFileSystem npoifs;
    private OPCPackage opcpkg;

    public PoiWorkbook(String filename, String encoding) throws KettleException {
        this(filename, encoding, null);
    }

    public PoiWorkbook(String filename, String encoding, String password) throws KettleException {
        block8: {
            this.filename = filename;
            this.encoding = encoding;
            this.log = KettleLogStore.getLogChannelInterfaceFactory().create((Object)this);
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)filename);
                if (fileObject instanceof LocalFile) {
                    String localFilename = KettleVFS.getFilename((FileObject)fileObject);
                    File excelFile = new File(localFilename);
                    try {
                        this.npoifs = new NPOIFSFileSystem(excelFile);
                        this.workbook = WorkbookFactory.create((NPOIFSFileSystem)this.npoifs);
                    }
                    catch (Exception ofe) {
                        try {
                            this.opcpkg = OPCPackage.open((File)excelFile);
                            this.workbook = WorkbookFactory.create((OPCPackage)this.opcpkg);
                            break block8;
                        }
                        catch (Exception ex) {
                            this.workbook = WorkbookFactory.create((File)excelFile, (String)password);
                        }
                    }
                    break block8;
                }
                this.internalIS = KettleVFS.getInputStream((String)filename);
                this.workbook = WorkbookFactory.create((InputStream)this.internalIS, (String)password);
            }
            catch (EncryptedDocumentException e) {
                this.log.logError("Unable to open spreadsheet.  If the spreadsheet is password protected please double check the password is correct.");
                throw new KettleException(e.getLocalizedMessage());
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    public PoiWorkbook(InputStream inputStream, String encoding) throws KettleException {
        this.encoding = encoding;
        try {
            this.workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.internalIS != null) {
                this.internalIS.close();
            }
            if (this.npoifs != null) {
                this.npoifs.close();
            }
            if (this.opcpkg != null) {
                this.opcpkg.revert();
            }
        }
        catch (IOException ex) {
            this.log.logError("Could not close workbook", (Throwable)ex);
        }
    }

    public KSheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }

    public String[] getSheetNames() {
        int nrSheets = this.workbook.getNumberOfSheets();
        String[] names = new String[nrSheets];
        for (int i = 0; i < nrSheets; ++i) {
            names[i] = this.workbook.getSheetName(i);
        }
        return names;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public KSheet getSheet(int sheetNr) {
        Sheet sheet = this.workbook.getSheetAt(sheetNr);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }

    public String getSheetName(int sheetNr) {
        Sheet sheet = (Sheet)this.getSheet(sheetNr);
        if (sheet == null) {
            return null;
        }
        return sheet.getSheetName();
    }
}

