/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.HTTPMeta;

public class HTTP
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HTTPMeta.class;
    private HTTPMeta meta;
    private HTTPData data;

    public HTTP(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] execHttp(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.argnrs = new int[this.meta.getArgumentField().length];
            for (int i = 0; i < this.meta.getArgumentField().length; ++i) {
                this.data.argnrs[i] = rowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                if (this.data.argnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArgumentField()[i] + "]");
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.CouldnotFindField", (String[])new String[]{this.meta.getArgumentField()[i]}));
            }
        }
        return this.callHttpService(rowMeta, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Object[] callHttpService(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        if (this.data.realConnectionTimeout > -1) {
            clientBuilder.setConnectionTimeout(this.data.realConnectionTimeout);
        }
        if (this.data.realSocketTimeout > -1) {
            clientBuilder.setSocketTimeout(this.data.realSocketTimeout);
        }
        if (StringUtils.isNotBlank((String)this.data.realHttpLogin)) {
            clientBuilder.setCredentials(this.data.realHttpLogin, this.data.realHttpPassword);
        }
        if (StringUtils.isNotBlank((String)this.data.realProxyHost)) {
            clientBuilder.setProxy(this.data.realProxyHost, this.data.realProxyPort);
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        URI uri = null;
        try {
            URIBuilder uriBuilder = this.constructUrlBuilder(rowMeta, rowData);
            uri = uriBuilder.build();
            HttpGet method = new HttpGet(uri);
            if (this.data.useHeaderParameters) {
                for (int i = 0; i < this.data.header_parameters_nrs.length; ++i) {
                    method.addHeader(this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i]));
                    if (!this.isDebug()) continue;
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.HeaderValue", (String[])new String[]{this.data.headerParameters[i].getName(), this.data.inputRowMeta.getString(rowData, this.data.header_parameters_nrs[i])}));
                }
            }
            Object[] newRow = null;
            if (rowData != null) {
                newRow = (Object[])rowData.clone();
            }
            CloseableHttpResponse httpResponse = null;
            try {
                String body;
                long startTime = System.currentTimeMillis();
                if (StringUtils.isNotBlank((String)this.data.realProxyHost)) {
                    HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    authCache.put(target, (AuthScheme)basicAuth);
                    HttpClientContext localContext = HttpClientContext.create();
                    localContext.setAuthCache((AuthCache)authCache);
                    httpResponse = httpClient.execute(target, (HttpRequest)method, (HttpContext)localContext);
                } else {
                    httpResponse = httpClient.execute((HttpUriRequest)method);
                }
                long responseTime = System.currentTimeMillis() - startTime;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseTime", (Object[])new Object[]{responseTime, uri}));
                }
                int statusCode = this.requestStatusCode((HttpResponse)httpResponse);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseStatusCode", (String[])new String[]{"" + statusCode}));
                }
                switch (statusCode) {
                    case 401: {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.Authentication", (String[])new String[]{this.data.realUrl}));
                    }
                    case -1: {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.IllegalStatusCode", (String[])new String[]{this.data.realUrl}));
                    }
                    case 204: {
                        body = "";
                        break;
                    }
                    default: {
                        HttpEntity entity = httpResponse.getEntity();
                        body = entity != null ? (StringUtils.isEmpty((String)this.meta.getEncoding()) ? EntityUtils.toString((HttpEntity)entity) : EntityUtils.toString((HttpEntity)entity, (String)this.meta.getEncoding())) : "";
                    }
                }
                Header[] headers = this.searchForHeaders(httpResponse);
                JSONObject json = new JSONObject();
                for (Header header : headers) {
                    ArrayList<String> list;
                    Object previousValue = json.get((Object)header.getName());
                    if (previousValue == null) {
                        json.put((Object)header.getName(), (Object)header.getValue());
                        continue;
                    }
                    if (previousValue instanceof List) {
                        list = (ArrayList<String>)previousValue;
                        list.add(header.getValue());
                        continue;
                    }
                    list = new ArrayList<String>();
                    list.add((String)previousValue);
                    list.add(header.getValue());
                    json.put((Object)header.getName(), list);
                }
                String headerString = json.toJSONString();
                int returnFieldsOffset = rowMeta.size();
                if (!Utils.isEmpty((CharSequence)this.meta.getFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResultCodeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(statusCode));
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResponseTimeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getResponseHeaderFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
                }
            }
            finally {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                method.releaseConnection();
            }
            return newRow;
        }
        catch (UnknownHostException uhe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableGetResult", (Object[])new Object[]{uri}), (Throwable)e);
        }
    }

    private URIBuilder constructUrlBuilder(RowMetaInterface outputRowMeta, Object[] row) throws KettleValueException, KettleException {
        URIBuilder uriBuilder;
        try {
            String baseUrl = this.data.realUrl;
            if (this.meta.isUrlInField()) {
                baseUrl = outputRowMeta.getString(row, this.data.indexOfUrlField);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.Connecting", (String[])new String[]{baseUrl}));
            }
            uriBuilder = new URIBuilder(baseUrl);
            for (int i = 0; i < this.data.argnrs.length; ++i) {
                String key = this.meta.getArgumentParameter()[i];
                String value = outputRowMeta.getString(row, this.data.argnrs[i]);
                uriBuilder.addParameter(key, value);
            }
            List queryParams = uriBuilder.getQueryParams();
            if (!queryParams.isEmpty()) {
                uriBuilder.setParameters(queryParams);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableCreateUrl", (String[])new String[0]), (Throwable)e);
        }
        return uriBuilder;
    }

    protected int requestStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected Header[] searchForHeaders(CloseableHttpResponse response) {
        return response.getAllHeaders();
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block14: {
            this.meta = (HTTPMeta)smi;
            this.data = (HTTPData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrHeaders;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputRowMeta = this.getInputRowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (this.meta.isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.getInputRowMeta().indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if ((nrHeaders = this.meta.getHeaderField().length) > 0) {
                    this.data.useHeaderParameters = true;
                }
                this.data.header_parameters_nrs = new int[nrHeaders];
                this.data.headerParameters = new NameValuePair[nrHeaders];
                for (int i = 0; i < nrHeaders; ++i) {
                    int fieldIndex = this.data.inputRowMeta.indexOfValue(this.meta.getHeaderField()[i]);
                    if (fieldIndex < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[0]) + this.meta.getHeaderField()[i] + "]");
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"HTTP.Exception.ErrorFindingField", (String[])new String[]{this.meta.getHeaderField()[i]}));
                    }
                    this.data.header_parameters_nrs[i] = fieldIndex;
                    this.data.headerParameters[i] = new BasicNameValuePair(this.environmentSubstitute(this.meta.getHeaderParameter()[i]), this.data.outputRowMeta.getString(r, this.data.header_parameters_nrs[i]));
                }
            }
            try {
                Object[] outputRowData = this.execHttp(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTP.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block14;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTP001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        if (super.init(smi, sdi)) {
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getHttpPassword());
            this.data.realSocketTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            this.data.realConnectionTimeout = Const.toInt((String)this.environmentSubstitute(this.meta.getSocketTimeout()), (int)-1);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        super.dispose(smi, sdi);
    }
}

