/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgpencryptstream;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgpencryptstream.PGPEncryptStream;
import org.pentaho.di.trans.steps.pgpencryptstream.PGPEncryptStreamData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class PGPEncryptStreamMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PGPEncryptStreamMeta.class;
    private String gpglocation;
    private String keyname;
    private String streamfield;
    private String resultfieldname;
    private boolean keynameInField;
    private String keynameFieldName;

    @Deprecated
    public void setGPGPLocation(String value) {
        this.setGPGLocation(value);
    }

    public void setGPGLocation(String value) {
        this.gpglocation = value;
    }

    public String getGPGLocation() {
        return this.gpglocation;
    }

    public String getStreamField() {
        return this.streamfield;
    }

    public void setStreamField(String streamfield) {
        this.streamfield = streamfield;
    }

    public String getKeynameFieldName() {
        return this.keynameFieldName;
    }

    public void setKeynameFieldName(String keynameFieldName) {
        this.keynameFieldName = keynameFieldName;
    }

    public boolean isKeynameInField() {
        return this.keynameInField;
    }

    public void setKeynameInField(boolean keynameInField) {
        this.keynameInField = keynameInField;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    @Deprecated
    public void setResultfieldname(String value) {
        this.setResultFieldName(value);
    }

    public void setResultFieldName(String value) {
        this.resultfieldname = value;
    }

    public String getKeyName() {
        return this.keyname;
    }

    public void setKeyName(String keyname) {
        this.keyname = keyname;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        PGPEncryptStreamMeta retval = (PGPEncryptStreamMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.resultfieldname = "result";
        this.streamfield = null;
        this.keyname = null;
        this.gpglocation = null;
        this.keynameInField = false;
        this.keynameFieldName = null;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)this.resultfieldname)) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.resultfieldname));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"gpglocation", (String)this.gpglocation));
        retval.append("    " + XMLHandler.addTagValue((String)"keyname", (String)this.keyname));
        retval.append("    " + XMLHandler.addTagValue((String)"keynameInField", (boolean)this.keynameInField));
        retval.append("    " + XMLHandler.addTagValue((String)"keynameFieldName", (String)this.keynameFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"streamfield", (String)this.streamfield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.gpglocation = XMLHandler.getTagValue((Node)stepnode, (String)"gpglocation");
            this.keyname = XMLHandler.getTagValue((Node)stepnode, (String)"keyname");
            this.keynameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"keynameInField"));
            this.keynameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"keynameFieldName");
            this.streamfield = XMLHandler.getTagValue((Node)stepnode, (String)"streamfield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.gpglocation = rep.getStepAttributeString(id_step, "gpglocation");
            this.keyname = rep.getStepAttributeString(id_step, "keyname");
            this.keynameInField = rep.getStepAttributeBoolean(id_step, "keynameInField");
            this.keynameFieldName = rep.getStepAttributeString(id_step, "keynameFieldName");
            this.streamfield = rep.getStepAttributeString(id_step, "streamfield");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "gpglocation", this.gpglocation);
            rep.saveStepAttribute(id_transformation, id_step, "keyname", this.keyname);
            rep.saveStepAttribute(id_transformation, id_step, "keynameInField", this.keynameInField);
            rep.saveStepAttribute(id_transformation, id_step, "keynameFieldName", this.keynameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "streamfield", this.streamfield);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Utils.isEmpty((CharSequence)this.gpglocation)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.GPGLocationMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.GPGLocationOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        if (!this.isKeynameInField()) {
            if (Utils.isEmpty((CharSequence)this.keyname)) {
                error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.KeyNameMissing", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.KeyNameOK", (String[])new String[0]);
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            }
        }
        if (Utils.isEmpty((CharSequence)this.resultfieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.streamfield)) {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.StreamFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.StreamFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PGPEncryptStream(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PGPEncryptStreamData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

