/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.zipfile;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.zipfile.ZipFile;
import org.pentaho.di.trans.steps.zipfile.ZipFileData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ZipFileMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ZipFileMeta.class;
    private String sourcefilenamefield;
    private String targetfilenamefield;
    private String baseFolderField;
    private String movetofolderfield;
    private boolean addresultfilenames;
    private boolean overwritezipentry;
    private boolean createparentfolder;
    private boolean keepsourcefolder;
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.DoNothing", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.Move", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.Delete", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"", "move", "delete"};
    public static final int OPERATION_TYPE_NOTHING = 0;
    public static final int OPERATION_TYPE_MOVE = 1;
    public static final int OPERATION_TYPE_DELETE = 2;

    public String getDynamicSourceFileNameField() {
        return this.sourcefilenamefield;
    }

    public void setDynamicSourceFileNameField(String sourcefilenamefield) {
        this.sourcefilenamefield = sourcefilenamefield;
    }

    public String getBaseFolderField() {
        return this.baseFolderField;
    }

    public void setBaseFolderField(String baseFolderField) {
        this.baseFolderField = baseFolderField;
    }

    public String getMoveToFolderField() {
        return this.movetofolderfield;
    }

    public void setMoveToFolderField(String movetofolderfield) {
        this.movetofolderfield = movetofolderfield;
    }

    public String getDynamicTargetFileNameField() {
        return this.targetfilenamefield;
    }

    public void setDynamicTargetFileNameField(String targetfilenamefield) {
        this.targetfilenamefield = targetfilenamefield;
    }

    public boolean isaddTargetFileNametoResult() {
        return this.addresultfilenames;
    }

    public boolean isOverwriteZipEntry() {
        return this.overwritezipentry;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public boolean isKeepSouceFolder() {
        return this.keepsourcefolder;
    }

    public void setKeepSouceFolder(boolean value) {
        this.keepsourcefolder = value;
    }

    public void setaddTargetFileNametoResult(boolean addresultfilenames) {
        this.addresultfilenames = addresultfilenames;
    }

    public void setOverwriteZipEntry(boolean overwritezipentry) {
        this.overwritezipentry = overwritezipentry;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        ZipFileMeta retval = (ZipFileMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.addresultfilenames = false;
        this.overwritezipentry = false;
        this.createparentfolder = false;
        this.keepsourcefolder = false;
        this.operationType = 0;
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"sourcefilenamefield", (String)this.sourcefilenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"targetfilenamefield", (String)this.targetfilenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"baseFolderField", (String)this.baseFolderField));
        retval.append("    " + XMLHandler.addTagValue((String)"operation_type", (String)ZipFileMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addresultfilenames", (boolean)this.addresultfilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overwritezipentry", (boolean)this.overwritezipentry));
        retval.append("    ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createparentfolder));
        retval.append("    ").append(XMLHandler.addTagValue((String)"keepsourcefolder", (boolean)this.keepsourcefolder));
        retval.append("    " + XMLHandler.addTagValue((String)"movetofolderfield", (String)this.movetofolderfield));
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.sourcefilenamefield);
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.targetfilenamefield);
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl(this.baseFolderField);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.sourcefilenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"sourcefilenamefield");
            this.targetfilenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"targetfilenamefield");
            this.baseFolderField = XMLHandler.getTagValue((Node)stepnode, (String)"baseFolderField");
            this.operationType = ZipFileMeta.getOperationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"operation_type"), (String)""));
            this.addresultfilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfilenames"));
            this.overwritezipentry = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overwritezipentry"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"createparentfolder"));
            this.keepsourcefolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"keepsourcefolder"));
            this.movetofolderfield = XMLHandler.getTagValue((Node)stepnode, (String)"movetofolderfield");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ZipFileMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.sourcefilenamefield = rep.getStepAttributeString(id_step, "sourcefilenamefield");
            this.targetfilenamefield = rep.getStepAttributeString(id_step, "targetfilenamefield");
            this.baseFolderField = rep.getStepAttributeString(id_step, "baseFolderField");
            this.operationType = ZipFileMeta.getOperationTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "operation_type"), (String)""));
            this.addresultfilenames = rep.getStepAttributeBoolean(id_step, "addresultfilenames");
            this.overwritezipentry = rep.getStepAttributeBoolean(id_step, "overwritezipentry");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "createparentfolder");
            this.keepsourcefolder = rep.getStepAttributeBoolean(id_step, "keepsourcefolder");
            this.movetofolderfield = rep.getStepAttributeString(id_step, "movetofolderfield");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFileMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "sourcefilenamefield", this.sourcefilenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "targetfilenamefield", this.targetfilenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "baseFolderField", this.baseFolderField);
            rep.saveStepAttribute(id_transformation, id_step, "operation_type", ZipFileMeta.getOperationTypeCode(this.operationType));
            rep.saveStepAttribute(id_transformation, id_step, "addresultfilenames", this.addresultfilenames);
            rep.saveStepAttribute(id_transformation, id_step, "overwritezipentry", this.overwritezipentry);
            rep.saveStepAttribute(id_transformation, id_step, "createparentfolder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "keepsourcefolder", this.keepsourcefolder);
            rep.saveStepAttribute(id_transformation, id_step, "movetofolderfield", this.movetofolderfield);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ZipFileMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Utils.isEmpty((CharSequence)this.sourcefilenamefield)) {
            error_message = BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.SourceFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.TargetFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ZipFile(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ZipFileData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ZipFileMeta.getOperationTypeByCode(tt);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }
}

