/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.CarteRequestHandler;

public abstract class BaseCartePlugin
extends BaseHttpServlet
implements CartePluginInterface,
CarteRequestHandler {
    @Override
    @Deprecated
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.isJettyMode() && !req.getContextPath().endsWith(this.getContextPath())) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.getService());
        }
        this.handleRequest(new CarteRequestImpl(req, resp));
    }

    @Override
    public abstract void handleRequest(CarteRequestHandler.CarteRequest var1) throws IOException;

    @Override
    public abstract String getContextPath();

    @Override
    public String getService() {
        return this.getContextPath() + " (" + this.toString() + ")";
    }

    public String toString() {
        CarteServlet carteServlet = this.getClass().getAnnotation(CarteServlet.class);
        return carteServlet != null ? carteServlet.name() : super.toString();
    }

    private static FluentIterable<String> fromEnumeration(Enumeration enumeration) {
        ArrayList list = Collections.list(enumeration);
        return FluentIterable.from(list).filter(String.class);
    }

    private class CarteRequestImpl
    implements CarteRequestHandler.CarteRequest {
        private final HttpServletRequest req;
        private final HttpServletResponse resp;

        public CarteRequestImpl(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        @Override
        public String getMethod() {
            return this.req.getMethod();
        }

        @Override
        public Map<String, Collection<String>> getHeaders() {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String name : BaseCartePlugin.fromEnumeration(this.req.getHeaderNames())) {
                builder.putAll((Object)name, (Iterable)BaseCartePlugin.fromEnumeration(this.req.getHeaders(name)));
            }
            return builder.build().asMap();
        }

        @Override
        public String getHeader(String name) {
            return this.req.getHeader(name);
        }

        @Override
        public Map<String, Collection<String>> getParameters() {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String name : BaseCartePlugin.fromEnumeration(this.req.getParameterNames())) {
                builder.putAll((Object)name, (Object[])this.req.getParameterValues(name));
            }
            return builder.build().asMap();
        }

        @Override
        public String getParameter(String name) {
            return this.req.getParameter(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.req.getInputStream();
        }

        @Override
        public CarteRequestHandler.CarteResponse respond(int status) {
            if (status >= 400) {
                try {
                    this.resp.sendError(status);
                }
                catch (IOException e) {
                    this.resp.setStatus(status);
                }
            } else {
                this.resp.setStatus(status);
            }
            return new CarteRequestHandler.CarteResponse(){

                @Override
                public void with(String contentType, CarteRequestHandler.WriterResponse response) throws IOException {
                    CarteRequestImpl.this.resp.setContentType(contentType);
                    response.write(CarteRequestImpl.this.resp.getWriter());
                }

                @Override
                public void with(String contentType, CarteRequestHandler.OutputStreamResponse response) throws IOException {
                    CarteRequestImpl.this.resp.setContentType(contentType);
                    response.write((OutputStream)CarteRequestImpl.this.resp.getOutputStream());
                }

                @Override
                public void withMessage(String text) throws IOException {
                    CarteRequestImpl.this.resp.setContentType("text/plain");
                    CarteRequestImpl.this.resp.getWriter().println(text);
                }
            };
        }
    }
}

