/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelFileWriter;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.AddTransServlet;
import org.pentaho.di.www.BodyHttpServlet;
import org.pentaho.di.www.CarteDelegationHandler;
import org.pentaho.metastore.api.IMetaStore;

public abstract class BaseJobServlet
extends BodyHttpServlet {
    private static final long serialVersionUID = 8523062215275251356L;

    protected Job createJob(JobConfiguration jobConfiguration) throws UnknownParamException {
        JobExecutionConfiguration jobExecutionConfiguration = jobConfiguration.getJobExecutionConfiguration();
        JobMeta jobMeta = jobConfiguration.getJobMeta();
        jobMeta.setLogLevel(jobExecutionConfiguration.getLogLevel());
        jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
        final Repository repository = jobConfiguration.getJobExecutionConfiguration().getRepository();
        String carteObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = this.getServletLogging(carteObjectId, jobExecutionConfiguration.getLogLevel());
        Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
        job.initializeVariablesFrom(null);
        job.getJobMeta().setMetaStore((IMetaStore)this.jobMap.getSlaveServerConfig().getMetaStore());
        job.getJobMeta().setInternalKettleVariables(job);
        job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
        job.setArguments(jobExecutionConfiguration.getArgumentStrings());
        job.setSocketRepository(this.getSocketRepository());
        this.copyJobParameters(job, jobExecutionConfiguration.getParams());
        String startCopyName = jobExecutionConfiguration.getStartCopyName();
        if (startCopyName != null && !startCopyName.isEmpty()) {
            int startCopyNr = jobExecutionConfiguration.getStartCopyNr();
            JobEntryCopy startJobEntryCopy = jobMeta.findJobEntry(startCopyName, startCopyNr, false);
            job.setStartJobEntryCopy(startJobEntryCopy);
        }
        if (jobExecutionConfiguration.isExpandingRemoteJob()) {
            job.addDelegationListener(new CarteDelegationHandler(this.getTransformationMap(), this.getJobMap()));
        }
        if (repository != null) {
            job.addJobListener(new JobAdapter(){

                @Override
                public void jobFinished(Job job) {
                    repository.disconnect();
                }
            });
        }
        this.getJobMap().addJob(job.getJobname(), carteObjectId, job, jobConfiguration);
        Long passedBatchId = jobExecutionConfiguration.getPassedBatchId();
        if (passedBatchId != null) {
            job.setPassedBatchId(passedBatchId);
        }
        return job;
    }

    protected Trans createTrans(TransConfiguration transConfiguration) throws UnknownParamException {
        Long passedBatchId;
        TransMeta transMeta = transConfiguration.getTransMeta();
        TransExecutionConfiguration transExecutionConfiguration = transConfiguration.getTransExecutionConfiguration();
        transMeta.setLogLevel(transExecutionConfiguration.getLogLevel());
        transMeta.injectVariables(transExecutionConfiguration.getVariables());
        this.copyParameters(transMeta, transExecutionConfiguration.getParams());
        String carteObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = this.getServletLogging(carteObjectId, transExecutionConfiguration.getLogLevel());
        Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
        trans.setMetaStore((IMetaStore)this.transformationMap.getSlaveServerConfig().getMetaStore());
        if (transExecutionConfiguration.isSetLogfile()) {
            String realLogFilename = transExecutionConfiguration.getLogFileName();
            try {
                FileUtil.createParentFolder(AddTransServlet.class, realLogFilename, transExecutionConfiguration.isCreateParentFolder(), trans.getLogChannel(), trans);
                final LogChannelFileWriter logChannelFileWriter = new LogChannelFileWriter(servletLoggingObject.getLogChannelId(), KettleVFS.getFileObject((String)realLogFilename), transExecutionConfiguration.isSetAppendLogfile());
                logChannelFileWriter.startLogging();
                trans.addTransListener(new TransAdapter(){

                    @Override
                    public void transFinished(Trans trans) throws KettleException {
                        if (logChannelFileWriter != null) {
                            logChannelFileWriter.stopLogging();
                        }
                    }
                });
            }
            catch (KettleException e) {
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        final Repository repository = transExecutionConfiguration.getRepository();
        trans.setRepository(repository);
        trans.setSocketRepository(this.getSocketRepository());
        trans.setContainerObjectId(carteObjectId);
        this.getTransformationMap().addTransformation(transMeta.getName(), carteObjectId, trans, transConfiguration);
        if (repository != null) {
            trans.addTransListener(new TransAdapter(){

                @Override
                public void transFinished(Trans trans) {
                    repository.disconnect();
                }
            });
        }
        if ((passedBatchId = transExecutionConfiguration.getPassedBatchId()) != null) {
            trans.setPassedBatchId(passedBatchId);
        }
        return trans;
    }

    private void copyParameters(AbstractMeta meta, Map<String, String> params) throws UnknownParamException {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String thisValue = entry.getValue();
            if (StringUtils.isBlank((String)thisValue)) continue;
            meta.setParameterValue(entry.getKey(), thisValue);
        }
    }

    private void copyJobParameters(Job job, Map<String, String> params) throws UnknownParamException {
        String[] parameterNames;
        JobMeta jobMeta = job.getJobMeta();
        job.copyParametersFrom(jobMeta);
        job.clearParameters();
        for (String parameterName : parameterNames = job.listParameters()) {
            String thisValue = params.get(parameterName);
            if (StringUtils.isBlank((String)thisValue)) continue;
            jobMeta.setParameterValue(parameterName, thisValue);
        }
        jobMeta.activateParameters();
    }

    private SimpleLoggingObject getServletLogging(String carteObjectId, LogLevel level) {
        SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getContextPath(), LoggingObjectType.CARTE, null);
        servletLoggingObject.setContainerObjectId(carteObjectId);
        servletLoggingObject.setLogLevel(level);
        servletLoggingObject.setLogChannelId(carteObjectId);
        return servletLoggingObject;
    }
}

