/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.xmlbeans.impl.piccolo.util.DuplicateKeyException;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.SlaveServerConfig;

public class JobMap {
    private final Map<CarteObjectEntry, Job> jobMap = new HashMap<CarteObjectEntry, Job>();
    private final Map<CarteObjectEntry, JobConfiguration> configurationMap = new HashMap<CarteObjectEntry, JobConfiguration>();
    private SlaveServerConfig slaveServerConfig;

    public synchronized void addJob(String jobName, String carteObjectId, Job job, JobConfiguration jobConfiguration) {
        CarteObjectEntry entry = new CarteObjectEntry(jobName, carteObjectId);
        this.jobMap.put(entry, job);
        this.configurationMap.put(entry, jobConfiguration);
    }

    public synchronized void registerJob(Job job, JobConfiguration jobConfiguration) {
        job.setContainerObjectId(UUID.randomUUID().toString());
        CarteObjectEntry entry = new CarteObjectEntry(job.getJobMeta().getName(), job.getContainerObjectId());
        this.jobMap.put(entry, job);
        this.configurationMap.put(entry, jobConfiguration);
    }

    public synchronized void replaceJob(CarteObjectEntry entry, Job job, JobConfiguration jobConfiguration) {
        this.jobMap.put(entry, job);
        this.configurationMap.put(entry, jobConfiguration);
    }

    public synchronized Job getJob(String jobName) {
        for (CarteObjectEntry entry : this.jobMap.keySet()) {
            if (!entry.getName().equals(jobName)) continue;
            return this.getJob(entry);
        }
        return null;
    }

    public synchronized Job getJob(CarteObjectEntry entry) {
        return this.jobMap.get(entry);
    }

    public synchronized JobConfiguration getConfiguration(String jobName) {
        for (CarteObjectEntry entry : this.configurationMap.keySet()) {
            if (!entry.getName().equals(jobName)) continue;
            return this.getConfiguration(entry);
        }
        return null;
    }

    public synchronized JobConfiguration getConfiguration(CarteObjectEntry entry) {
        return this.configurationMap.get(entry);
    }

    public synchronized void removeJob(CarteObjectEntry entry) {
        this.jobMap.remove(entry);
        this.configurationMap.remove(entry);
    }

    public synchronized List<CarteObjectEntry> getJobObjects() {
        return new ArrayList<CarteObjectEntry>(this.jobMap.keySet());
    }

    public synchronized CarteObjectEntry getFirstCarteObjectEntry(String jobName) {
        for (CarteObjectEntry key : this.jobMap.keySet()) {
            if (!key.getName().equals(jobName)) continue;
            return key;
        }
        return null;
    }

    public synchronized CarteObjectEntry getUniqueCarteObjectEntry(String jobName) throws DuplicateKeyException {
        CarteObjectEntry entry = null;
        boolean unique = true;
        for (CarteObjectEntry key : this.jobMap.keySet()) {
            if (unique && key.getName().equals(jobName)) {
                unique = false;
                entry = key;
                continue;
            }
            if (unique || !key.getName().equals(jobName)) continue;
            throw new DuplicateKeyException();
        }
        return entry;
    }

    public SlaveServerConfig getSlaveServerConfig() {
        return this.slaveServerConfig;
    }

    public void setSlaveServerConfig(SlaveServerConfig slaveServerConfig) {
        this.slaveServerConfig = slaveServerConfig;
    }

    public synchronized Job findJob(String id) {
        for (Job job : this.jobMap.values()) {
            if (!job.getContainerObjectId().equals(id)) continue;
            return job;
        }
        return null;
    }
}

