/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.jaxrs;

import java.util.Map;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.jaxrs.CarteResource;
import org.pentaho.di.www.jaxrs.TransformationStatus;

@Path(value="/carte/trans")
public class TransformationResource {
    @GET
    @Path(value="/log/{id : .+}")
    @Produces(value={"text/plain"})
    public String getTransformationLog(@PathParam(value="id") String id) {
        return this.getTransformationLog(id, 0);
    }

    @GET
    @Path(value="/log/{id : .+}/{logStart : .+}")
    @Produces(value={"text/plain"})
    public String getTransformationLog(@PathParam(value="id") String id, @PathParam(value="logStart") int startLineNr) {
        int lastLineNr = KettleLogStore.getLastBufferLineNr();
        Trans trans = CarteResource.getTransformation(id);
        String logText = KettleLogStore.getAppender().getBuffer(trans.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
        return logText;
    }

    @GET
    @Path(value="/status/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus getTransformationStatus(@PathParam(value="id") String id) {
        TransformationStatus status = new TransformationStatus();
        Trans trans = CarteResource.getTransformation(id);
        CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
        status.setId(entry.getId());
        status.setName(entry.getName());
        status.setStatus(trans.getStatus());
        for (int i = 0; i < trans.nrSteps(); ++i) {
            StepInterface step = trans.getRunThread(i);
            if (!step.isRunning() && step.getStatus() == BaseStepData.StepExecutionStatus.STATUS_EMPTY) continue;
            StepStatus stepStatus = new StepStatus(step);
            status.addStepStatus(stepStatus);
        }
        return status;
    }

    @GET
    @Path(value="/start/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus startTransformation(@PathParam(value="id") String id) {
        Trans trans = CarteResource.getTransformation(id);
        try {
            KettleLogStore.discardLines((String)trans.getLogChannelId(), (boolean)true);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(trans.getLogLevel());
            trans.setParent((LoggingObjectInterface)servletLoggingObject);
            trans.execute(null);
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/prepare/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus prepareTransformation(@PathParam(value="id") String id) {
        Trans trans = CarteResource.getTransformation(id);
        try {
            CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
            TransConfiguration transConfiguration = CarteSingleton.getInstance().getTransformationMap().getConfiguration(entry);
            TransExecutionConfiguration executionConfiguration = transConfiguration.getTransExecutionConfiguration();
            trans.setArguments(executionConfiguration.getArgumentStrings());
            trans.setReplayDate(executionConfiguration.getReplayDate());
            trans.setSafeModeEnabled(executionConfiguration.isSafeModeEnabled());
            trans.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
            trans.injectVariables(executionConfiguration.getVariables());
            trans.setPreviousResult(executionConfiguration.getPreviousResult());
            trans.prepareExecution(null);
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/pause/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus pauseTransformation(@PathParam(value="id") String id) {
        CarteResource.getTransformation(id).pauseRunning();
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/resume/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus resumeTransformation(@PathParam(value="id") String id) {
        CarteResource.getTransformation(id).resumeRunning();
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/stop/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus stopTransformation(@PathParam(value="id") String id) {
        CarteResource.getTransformation(id).stopAll();
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/safeStop/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus safeStopTransformation(@PathParam(value="id") String id) {
        CarteResource.getTransformation(id).safeStop();
        return this.getTransformationStatus(id);
    }

    @GET
    @Path(value="/remove/{id : .+}")
    public Response removeTransformation(@PathParam(value="id") String id) {
        Trans trans = CarteResource.getTransformation(id);
        CarteObjectEntry entry = CarteResource.getCarteObjectEntry(id);
        KettleLogStore.discardLines((String)trans.getLogChannelId(), (boolean)true);
        CarteSingleton.getInstance().getTransformationMap().removeTransformation(entry);
        return Response.ok().build();
    }

    @GET
    @Path(value="/cleanup/{id : .+}")
    @Produces(value={"application/json"})
    public TransformationStatus cleanupTransformation(@PathParam(value="id") String id) {
        CarteResource.getTransformation(id).cleanup();
        return this.getTransformationStatus(id);
    }

    @PUT
    @Path(value="/add")
    @Produces(value={"application/json"})
    public TransformationStatus addTransformation(String xml) {
        try {
            TransConfiguration transConfiguration = TransConfiguration.fromXML(xml.toString());
            TransMeta transMeta = transConfiguration.getTransMeta();
            TransExecutionConfiguration transExecutionConfiguration = transConfiguration.getTransExecutionConfiguration();
            transMeta.setLogLevel(transExecutionConfiguration.getLogLevel());
            LogChannelInterface log = CarteSingleton.getInstance().getLog();
            if (log.isDetailed()) {
                log.logDetailed("Logging level set to " + log.getLogLevel().getDescription());
            }
            transMeta.injectVariables(transExecutionConfiguration.getVariables());
            Map<String, String> params = transExecutionConfiguration.getParams();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                transMeta.setParameterValue(entry.getKey(), entry.getValue());
            }
            TransExecutionConfiguration executionConfiguration = transConfiguration.getTransExecutionConfiguration();
            final Repository repository = transConfiguration.getTransExecutionConfiguration().getRepository();
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
            Trans trans = new Trans(transMeta, (LoggingObjectInterface)servletLoggingObject);
            trans.setRepository(repository);
            trans.setSocketRepository(CarteSingleton.getInstance().getSocketRepository());
            CarteSingleton.getInstance().getTransformationMap().addTransformation(transMeta.getName(), carteObjectId, trans, transConfiguration);
            trans.setContainerObjectId(carteObjectId);
            if (repository != null) {
                trans.addTransListener(new TransAdapter(){

                    @Override
                    public void transFinished(Trans trans) {
                        repository.disconnect();
                    }
                });
            }
            return this.getTransformationStatus(carteObjectId);
        }
        catch (KettleException e) {
            e.printStackTrace();
            return null;
        }
    }
}

